/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.introspection.JexlUberspect;

class FqcnResolver
implements JexlContext.ClassNameResolver {
    private final JexlUberspect uberspect;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Set<String> imports = new LinkedHashSet<String>();
    private final Map<String, String> fqcns = new HashMap<String, String>();
    private final FqcnResolver parent;

    private void importCheck(Iterable<String> names) {
        if (names != null) {
            names.forEach(this::importCheck);
        }
    }

    private void importCheck(String name) {
        if (name != null && Package.getPackage(name) != null) {
            this.imports.add(name);
        }
    }

    @Override
    public String resolveClassName(String name) {
        return this.getQualifiedName(name);
    }

    FqcnResolver(JexlUberspect uber, Iterable<String> packages) {
        this.uberspect = uber;
        this.parent = null;
        this.importCheck(packages);
    }

    FqcnResolver(FqcnResolver solver) {
        if (solver == null) {
            throw new NullPointerException("parent solver can not be null");
        }
        this.parent = solver;
        this.uberspect = solver.uberspect;
    }

    boolean isImporting(String pkg) {
        if (this.parent != null && this.parent.isImporting(pkg)) {
            return true;
        }
        this.lock.readLock().lock();
        try {
            boolean bl = this.imports.contains(pkg);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    FqcnResolver importPackages(Iterable<String> packages) {
        if (packages != null) {
            this.lock.writeLock().lock();
            try {
                if (this.parent == null) {
                    this.importCheck(packages);
                } else {
                    packages.forEach(pkg -> {
                        if (!this.parent.isImporting((String)pkg)) {
                            this.importCheck((String)pkg);
                        }
                    });
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getQualifiedName(String name) {
        String fqcn;
        if (this.parent != null && (fqcn = this.parent.getQualifiedName(name)) != null) {
            return fqcn;
        }
        this.lock.readLock().lock();
        try {
            fqcn = this.fqcns.get(name);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (fqcn == null) {
            ClassLoader loader = this.uberspect.getClassLoader();
            for (String pkg : this.imports) {
                Class<?> clazz;
                try {
                    clazz = loader.loadClass(pkg + "." + name);
                }
                catch (ClassNotFoundException e2) {
                    continue;
                }
                if (clazz == null) continue;
                fqcn = clazz.getName();
                this.lock.writeLock().lock();
                try {
                    this.fqcns.put(name, fqcn);
                    break;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return fqcn;
    }
}

