/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.internal.IntegerRange;
import org.apache.commons.jexl3.internal.LongRange;
import org.apache.commons.jexl3.internal.introspection.ArrayListWrapper;
import org.apache.commons.jexl3.introspection.JexlMethod;

public class JexlArithmetic {
    protected static final BigDecimal BIGD_DOUBLE_MAX_VALUE = BigDecimal.valueOf(Double.MAX_VALUE);
    protected static final BigDecimal BIGD_DOUBLE_MIN_VALUE = BigDecimal.valueOf(Double.MIN_VALUE);
    protected static final BigInteger BIGI_LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigInteger BIGI_LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    protected static final int BIGD_SCALE = -1;
    private final boolean strict;
    private final MathContext mathContext;
    private final int mathScale;
    private final Constructor<? extends JexlArithmetic> ctor;
    public static final Pattern FLOAT_PATTERN = Pattern.compile("^[+-]?\\d*(\\.\\d*)?([eE][+-]?\\d+)?$");
    private final boolean compare321 = JexlArithmetic.computeCompare321(this);

    public JexlArithmetic(boolean astrict) {
        this(astrict, null, Integer.MIN_VALUE);
    }

    public JexlArithmetic(boolean astrict, MathContext bigdContext, int bigdScale) {
        this.strict = astrict;
        this.mathContext = bigdContext == null ? MathContext.DECIMAL128 : bigdContext;
        this.mathScale = bigdScale == Integer.MIN_VALUE ? -1 : bigdScale;
        Constructor<?> actor = null;
        try {
            actor = this.getClass().getConstructor(Boolean.TYPE, MathContext.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ctor = actor;
    }

    public JexlArithmetic options(JexlOptions options) {
        if (options != null) {
            int bigdScale;
            boolean ostrict = options.isStrictArithmetic();
            MathContext bigdContext = options.getMathContext();
            if (bigdContext == null) {
                bigdContext = this.getMathContext();
            }
            if ((bigdScale = options.getMathScale()) == Integer.MIN_VALUE) {
                bigdScale = this.getMathScale();
            }
            if (ostrict != this.isStrict() || bigdScale != this.getMathScale() || bigdContext != this.getMathContext()) {
                return this.createWithOptions(ostrict, bigdContext, bigdScale);
            }
        }
        return this;
    }

    @Deprecated
    public JexlArithmetic options(JexlEngine.Options options) {
        if (options != null) {
            int bigdScale;
            MathContext bigdContext;
            Boolean ostrict = options.isStrictArithmetic();
            if (ostrict == null) {
                ostrict = this.isStrict();
            }
            if ((bigdContext = options.getArithmeticMathContext()) == null) {
                bigdContext = this.getMathContext();
            }
            if ((bigdScale = options.getArithmeticMathScale()) == Integer.MIN_VALUE) {
                bigdScale = this.getMathScale();
            }
            if (ostrict.booleanValue() != this.isStrict() || bigdScale != this.getMathScale() || bigdContext != this.getMathContext()) {
                return this.createWithOptions(ostrict, bigdContext, bigdScale);
            }
        }
        return this;
    }

    public JexlArithmetic options(JexlContext context) {
        if (context instanceof JexlContext.OptionsHandle) {
            return this.options(((JexlContext.OptionsHandle)((Object)context)).getEngineOptions());
        }
        if (context instanceof JexlEngine.Options) {
            return this.options((JexlEngine.Options)((Object)context));
        }
        return this;
    }

    protected JexlArithmetic createWithOptions(boolean astrict, MathContext bigdContext, int bigdScale) {
        if (this.ctor != null) {
            try {
                return this.ctor.newInstance(astrict, bigdContext, bigdScale);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return new JexlArithmetic(astrict, bigdContext, bigdScale);
    }

    public ArrayBuilder arrayBuilder(int size) {
        return new org.apache.commons.jexl3.internal.ArrayBuilder(size);
    }

    public SetBuilder setBuilder(int size) {
        return new org.apache.commons.jexl3.internal.SetBuilder(size);
    }

    public MapBuilder mapBuilder(int size) {
        return new org.apache.commons.jexl3.internal.MapBuilder(size);
    }

    public Iterable<?> createRange(Object from, Object to) throws ArithmeticException {
        long lfrom = this.toLong(from);
        long lto = this.toLong(to);
        if (lfrom >= Integer.MIN_VALUE && lfrom <= Integer.MAX_VALUE && lto >= Integer.MIN_VALUE && lto <= Integer.MAX_VALUE) {
            return IntegerRange.create((int)lfrom, (int)lto);
        }
        return LongRange.create(lfrom, lto);
    }

    protected boolean isNullOperand(Object value) {
        return value == null;
    }

    protected <T> T controlNullOperand(boolean strictCast, T defaultValue) {
        if (strictCast) {
            throw new NullOperand();
        }
        return defaultValue;
    }

    protected Object controlNullNullOperands(JexlOperator operator) {
        if (this.isStrict(operator)) {
            throw new NullOperand();
        }
        return 0;
    }

    protected boolean toBoolean(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, false).booleanValue() : this.toBoolean(val);
    }

    public boolean toBoolean(Object val) {
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            double number = this.toDouble(this.strict, val);
            return !Double.isNaN(number) && number != 0.0;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get();
        }
        if (val instanceof String) {
            String strval = val.toString();
            return !strval.isEmpty() && !"false".equals(strval);
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, false);
        }
        return true;
    }

    protected int toInteger(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, 0).intValue() : this.toInteger(val);
    }

    public int toInteger(Object val) {
        if (val instanceof Double) {
            double dval = (Double)val;
            return Double.isNaN(dval) ? 0 : (int)dval;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof String) {
            return this.parseInteger((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1 : 0;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get() ? 1 : 0;
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, 0);
        }
        throw new ArithmeticException("Integer coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected long toLong(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, 0L).longValue() : this.toLong(val);
    }

    public long toLong(Object val) {
        if (val instanceof Double) {
            double dval = (Double)val;
            return Double.isNaN(dval) ? 0L : (long)dval;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val instanceof String) {
            return this.parseLong((String)val);
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1L : 0L;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get() ? 1L : 0L;
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, 0L);
        }
        throw new ArithmeticException("Long coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected BigInteger toBigInteger(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, BigInteger.ZERO) : this.toBigInteger(val);
    }

    public BigInteger toBigInteger(Object val) {
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val instanceof Double) {
            Double dval = (Double)val;
            if (Double.isNaN(dval)) {
                return BigInteger.ZERO;
            }
            return BigInteger.valueOf(dval.longValue());
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).toBigInteger();
        }
        if (val instanceof Number) {
            return BigInteger.valueOf(((Number)val).longValue());
        }
        if (val instanceof Boolean) {
            return BigInteger.valueOf((Boolean)val != false ? 1L : 0L);
        }
        if (val instanceof AtomicBoolean) {
            return BigInteger.valueOf(((AtomicBoolean)val).get() ? 1L : 0L);
        }
        if (val instanceof String) {
            return this.parseBigInteger((String)val);
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return BigInteger.valueOf(i);
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, BigInteger.ZERO);
        }
        throw new ArithmeticException("BigInteger coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected BigDecimal toBigDecimal(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, BigDecimal.ZERO) : this.toBigDecimal(val);
    }

    public BigDecimal toBigDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return this.roundBigDecimal((BigDecimal)val);
        }
        if (val instanceof Double) {
            if (Double.isNaN((Double)val)) {
                return BigDecimal.ZERO;
            }
            return this.roundBigDecimal(new BigDecimal(val.toString(), this.getMathContext()));
        }
        if (val instanceof Number) {
            return this.roundBigDecimal(new BigDecimal(val.toString(), this.getMathContext()));
        }
        if (val instanceof Boolean) {
            return BigDecimal.valueOf((Boolean)val != false ? 1.0 : 0.0);
        }
        if (val instanceof AtomicBoolean) {
            return BigDecimal.valueOf(((AtomicBoolean)val).get() ? 1L : 0L);
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string)) {
                return BigDecimal.ZERO;
            }
            return this.roundBigDecimal(new BigDecimal(string, this.getMathContext()));
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return new BigDecimal(i);
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, BigDecimal.ZERO);
        }
        throw new ArithmeticException("BigDecimal coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected double toDouble(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, 0.0).doubleValue() : this.toDouble(val);
    }

    public double toDouble(Object val) {
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return Double.parseDouble(String.valueOf(val));
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get() ? 1.0 : 0.0;
        }
        if (val instanceof String) {
            return this.parseDouble((String)val);
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val == null) {
            return this.controlNullOperand(this.strict, 0.0);
        }
        throw new ArithmeticException("Double coercion: " + val.getClass().getName() + ":(" + val + ")");
    }

    protected String toString(boolean strict, Object val) {
        return this.isNullOperand(val) ? this.controlNullOperand(strict, "") : this.toString(val);
    }

    public String toString(Object val) {
        if (val instanceof Double) {
            Double dval = (Double)val;
            if (Double.isNaN(dval)) {
                return "";
            }
            return dval.toString();
        }
        return val == null ? this.controlNullOperand(this.strict, "") : val.toString();
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isStrict(JexlOperator operator) {
        if (operator != null) {
            switch (operator) {
                case EQ: 
                case ARRAY_GET: 
                case ARRAY_SET: 
                case PROPERTY_GET: 
                case PROPERTY_SET: 
                case EMPTY: 
                case SIZE: 
                case CONTAINS: {
                    return false;
                }
            }
            return this.isStrict();
        }
        return this.isStrict();
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public int getMathScale() {
        return this.mathScale;
    }

    protected BigDecimal roundBigDecimal(BigDecimal number) {
        int mscale = this.getMathScale();
        if (mscale >= 0) {
            return number.setScale(mscale, this.getMathContext().getRoundingMode());
        }
        return number;
    }

    @Deprecated
    protected Object controlNullNullOperands() {
        if (this.isStrict()) {
            throw new NullOperand();
        }
        return 0;
    }

    @Deprecated
    protected void controlNullOperand() {
        if (this.isStrict()) {
            throw new NullOperand();
        }
    }

    protected boolean isFloatingPointNumber(Object val) {
        if (val instanceof Float || val instanceof Double) {
            return true;
        }
        if (val instanceof CharSequence) {
            Matcher m = FLOAT_PATTERN.matcher((CharSequence)val);
            return m.matches() && (m.start(1) >= 0 || m.start(2) >= 0);
        }
        return false;
    }

    protected boolean isFloatingPoint(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    protected boolean isNumberable(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Short || o instanceof Character;
    }

    public Object controlReturn(Object returned) {
        return returned;
    }

    public Number narrow(Number original) {
        return this.narrowNumber(original, null);
    }

    protected boolean narrowAccept(Class<?> narrow, Class<?> source) {
        return narrow == null || narrow.equals(source);
    }

    public Number narrowNumber(Number original, Class<?> narrow) {
        if (original == null) {
            return null;
        }
        Number result = original;
        if (original instanceof BigDecimal) {
            BigDecimal bigd = (BigDecimal)original;
            if (bigd.compareTo(BIGD_DOUBLE_MAX_VALUE) > 0 || bigd.compareTo(BIGD_DOUBLE_MIN_VALUE) < 0) {
                return original;
            }
            try {
                long l = bigd.longValueExact();
                if (this.narrowAccept(narrow, Integer.class) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    return (int)l;
                }
                if (this.narrowAccept(narrow, Long.class)) {
                    return l;
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        if (original instanceof Double || original instanceof Float) {
            double value = original.doubleValue();
            if (this.narrowAccept(narrow, Float.class) && value <= 3.4028234663852886E38 && value >= (double)1.4E-45f) {
                result = Float.valueOf(result.floatValue());
            }
        } else {
            BigInteger bigi;
            if (original instanceof BigInteger && ((bigi = (BigInteger)original).compareTo(BIGI_LONG_MAX_VALUE) > 0 || bigi.compareTo(BIGI_LONG_MIN_VALUE) < 0)) {
                return original;
            }
            long value = original.longValue();
            if (this.narrowAccept(narrow, Byte.class) && value <= 127L && value >= -128L) {
                result = (byte)value;
            } else if (this.narrowAccept(narrow, Short.class) && value <= 32767L && value >= -32768L) {
                result = (short)value;
            } else if (this.narrowAccept(narrow, Integer.class) && value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                result = (int)value;
            }
        }
        return result;
    }

    protected Number narrowBigInteger(Object lhs, Object rhs, BigInteger bigi) {
        if ((this.isNumberable(lhs) || this.isNumberable(rhs)) && bigi.compareTo(BIGI_LONG_MAX_VALUE) <= 0 && bigi.compareTo(BIGI_LONG_MIN_VALUE) >= 0) {
            long l = bigi.longValue();
            if (!(lhs instanceof Long) && !(rhs instanceof Long) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (int)l;
            }
            return l;
        }
        return bigi;
    }

    protected Number narrowBigDecimal(Object lhs, Object rhs, BigDecimal bigd) {
        if (this.isNumberable(lhs) || this.isNumberable(rhs)) {
            try {
                long l = bigd.longValueExact();
                if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                    return (int)l;
                }
                return l;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return bigd;
    }

    public boolean narrowArguments(Object[] args) {
        boolean narrowed = false;
        if (args != null) {
            for (int a = 0; a < args.length; ++a) {
                Number narrow;
                Number narg;
                Object arg = args[a];
                if (!(arg instanceof Number) || (narg = (Number)arg).equals(narrow = this.narrow(narg))) continue;
                args[a] = narrow;
                narrowed = true;
            }
        }
        return narrowed;
    }

    protected Number narrowLong(Object lhs, Object rhs, long r) {
        if (!(lhs instanceof Long) && !(rhs instanceof Long) && (long)((int)r) == r) {
            return (int)r;
        }
        return r;
    }

    protected Number asLongNumber(Object value) {
        return value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte ? (Number)value : null;
    }

    public Object increment(Object val) {
        return this.increment(val, 1);
    }

    public Object decrement(Object val) {
        return this.increment(val, -1);
    }

    protected Object increment(Object val, int incr) {
        if (val == null) {
            return incr;
        }
        if (val instanceof Integer) {
            return (Integer)val + incr;
        }
        if (val instanceof Double) {
            return (Double)val + (double)incr;
        }
        if (val instanceof Long) {
            return (Long)val + (long)incr;
        }
        if (val instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)val;
            return bd.add(BigDecimal.valueOf(incr), this.mathContext);
        }
        if (val instanceof BigInteger) {
            BigInteger bi = (BigInteger)val;
            return bi.add(BigInteger.valueOf(incr));
        }
        if (val instanceof Float) {
            return Float.valueOf(((Float)val).floatValue() + (float)incr);
        }
        if (val instanceof Short) {
            return (short)((Short)val + incr);
        }
        if (val instanceof Byte) {
            return (byte)((Byte)val + incr);
        }
        throw new ArithmeticException("Object " + (incr < 0 ? "decrement" : "increment") + ":(" + val + ")");
    }

    public Object add(Object left, Object right) {
        boolean strconcat;
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.ADD);
        }
        boolean bl = this.strict ? left instanceof String || right instanceof String : (strconcat = left instanceof String && right instanceof String);
        if (!strconcat) {
            try {
                Number ln = this.asLongNumber(left);
                Number rn = this.asLongNumber(right);
                if (ln != null && rn != null) {
                    long y;
                    long result;
                    long x2 = ln.longValue();
                    if (((x2 ^ (result = x2 + (y = rn.longValue()))) & (y ^ result)) < 0L) {
                        return BigInteger.valueOf(x2).add(BigInteger.valueOf(y));
                    }
                    return this.narrowLong(left, right, result);
                }
                boolean strictCast = this.isStrict(JexlOperator.ADD);
                if (left instanceof BigDecimal || right instanceof BigDecimal) {
                    BigDecimal l = this.toBigDecimal(strictCast, left);
                    BigDecimal r = this.toBigDecimal(strictCast, right);
                    BigDecimal result = l.add(r, this.getMathContext());
                    return this.narrowBigDecimal(left, right, result);
                }
                if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
                    double l = this.toDouble(strictCast, left);
                    double r = this.toDouble(strictCast, right);
                    return l + r;
                }
                BigInteger l = this.toBigInteger(strictCast, left);
                BigInteger r = this.toBigInteger(strictCast, right);
                BigInteger result = l.add(r);
                return this.narrowBigInteger(left, right, result);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return (left == null ? "" : this.toString(left)).concat(right == null ? "" : this.toString(right));
    }

    public Object divide(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.DIVIDE);
        }
        Number ln = this.asLongNumber(left);
        Number rn = this.asLongNumber(right);
        if (ln != null && rn != null) {
            long x2 = ln.longValue();
            long y = rn.longValue();
            if (y == 0L) {
                throw new ArithmeticException("/");
            }
            long result = x2 / y;
            return this.narrowLong(left, right, result);
        }
        boolean strictCast = this.isStrict(JexlOperator.DIVIDE);
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(strictCast, left);
            BigDecimal r = this.toBigDecimal(strictCast, right);
            if (BigDecimal.ZERO.equals(r)) {
                throw new ArithmeticException("/");
            }
            BigDecimal result = l.divide(r, this.getMathContext());
            return this.narrowBigDecimal(left, right, result);
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(strictCast, left);
            double r = this.toDouble(strictCast, right);
            if (r == 0.0) {
                throw new ArithmeticException("/");
            }
            return l / r;
        }
        BigInteger l = this.toBigInteger(strictCast, left);
        BigInteger r = this.toBigInteger(strictCast, right);
        if (BigInteger.ZERO.equals(r)) {
            throw new ArithmeticException("/");
        }
        BigInteger result = l.divide(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object mod(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.MOD);
        }
        Number ln = this.asLongNumber(left);
        Number rn = this.asLongNumber(right);
        if (ln != null && rn != null) {
            long x2 = ln.longValue();
            long y = rn.longValue();
            if (y == 0L) {
                throw new ArithmeticException("%");
            }
            long result = x2 % y;
            return this.narrowLong(left, right, result);
        }
        boolean strictCast = this.isStrict(JexlOperator.MOD);
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(strictCast, left);
            BigDecimal r = this.toBigDecimal(strictCast, right);
            if (BigDecimal.ZERO.equals(r)) {
                throw new ArithmeticException("%");
            }
            BigDecimal remainder = l.remainder(r, this.getMathContext());
            return this.narrowBigDecimal(left, right, remainder);
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(strictCast, left);
            double r = this.toDouble(strictCast, right);
            if (r == 0.0) {
                throw new ArithmeticException("%");
            }
            return l % r;
        }
        BigInteger l = this.toBigInteger(strictCast, left);
        BigInteger r = this.toBigInteger(strictCast, right);
        if (BigInteger.ZERO.equals(r)) {
            throw new ArithmeticException("%");
        }
        BigInteger result = l.mod(r);
        return this.narrowBigInteger(left, right, result);
    }

    protected static boolean isMultiplyExact(long x2, long y, long r) {
        long ay;
        long ax = Math.abs(x2);
        return (ax | (ay = Math.abs(y))) >>> 31 == 0L || (y == 0L || r / y == x2) && (x2 != Long.MIN_VALUE || y != -1L);
    }

    public Object multiply(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.MULTIPLY);
        }
        Number ln = this.asLongNumber(left);
        Number rn = this.asLongNumber(right);
        if (ln != null && rn != null) {
            long result;
            long y;
            long x2 = ln.longValue();
            if (!JexlArithmetic.isMultiplyExact(x2, y = rn.longValue(), result = x2 * y)) {
                return BigInteger.valueOf(x2).multiply(BigInteger.valueOf(y));
            }
            return this.narrowLong(left, right, result);
        }
        boolean strictCast = this.isStrict(JexlOperator.MULTIPLY);
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(strictCast, left);
            BigDecimal r = this.toBigDecimal(strictCast, right);
            BigDecimal result = l.multiply(r, this.getMathContext());
            return this.narrowBigDecimal(left, right, result);
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(strictCast, left);
            double r = this.toDouble(strictCast, right);
            return l * r;
        }
        BigInteger l = this.toBigInteger(strictCast, left);
        BigInteger r = this.toBigInteger(strictCast, right);
        BigInteger result = l.multiply(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object subtract(Object left, Object right) {
        if (left == null && right == null) {
            return this.controlNullNullOperands(JexlOperator.SUBTRACT);
        }
        Number ln = this.asLongNumber(left);
        Number rn = this.asLongNumber(right);
        if (ln != null && rn != null) {
            long result;
            long y;
            long x2 = ln.longValue();
            if (((x2 ^ (y = rn.longValue())) & (x2 ^ (result = x2 - y))) < 0L) {
                return BigInteger.valueOf(x2).subtract(BigInteger.valueOf(y));
            }
            return this.narrowLong(left, right, result);
        }
        boolean strictCast = this.isStrict(JexlOperator.SUBTRACT);
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            BigDecimal l = this.toBigDecimal(strictCast, left);
            BigDecimal r = this.toBigDecimal(strictCast, right);
            BigDecimal result = l.subtract(r, this.getMathContext());
            return this.narrowBigDecimal(left, right, result);
        }
        if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
            double l = this.toDouble(strictCast, left);
            double r = this.toDouble(strictCast, right);
            return l - r;
        }
        BigInteger l = this.toBigInteger(strictCast, left);
        BigInteger r = this.toBigInteger(strictCast, right);
        BigInteger result = l.subtract(r);
        return this.narrowBigInteger(left, right, result);
    }

    public Object negate(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return -((Integer)val).intValue();
        }
        if (val instanceof Double) {
            return -((Double)val).doubleValue();
        }
        if (val instanceof Long) {
            return -((Long)val).longValue();
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).negate();
        }
        if (val instanceof BigInteger) {
            return ((BigInteger)val).negate();
        }
        if (val instanceof Float) {
            return Float.valueOf(-((Float)val).floatValue());
        }
        if (val instanceof Short) {
            return -((Short)val).shortValue();
        }
        if (val instanceof Byte) {
            return -((Byte)val).byteValue();
        }
        if (val instanceof Boolean) {
            return (Boolean)val == false;
        }
        if (val instanceof AtomicBoolean) {
            return !((AtomicBoolean)val).get();
        }
        throw new ArithmeticException("Object negate:(" + val + ")");
    }

    public boolean isNegateStable() {
        return true;
    }

    public Object positivize(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Short) {
            return ((Short)val).intValue();
        }
        if (val instanceof Byte) {
            return ((Byte)val).intValue();
        }
        if (val instanceof Number) {
            return val;
        }
        if (val instanceof Character) {
            return (int)((Character)val).charValue();
        }
        if (val instanceof Boolean) {
            return val;
        }
        if (val instanceof AtomicBoolean) {
            return ((AtomicBoolean)val).get();
        }
        throw new ArithmeticException("Object positivize:(" + val + ")");
    }

    public boolean isPositivizeStable() {
        return true;
    }

    public boolean testPredicate(Object object) {
        boolean strictCast = this.isStrict(JexlOperator.CONDITION);
        return this.toBoolean(strictCast, object);
    }

    public Boolean contains(Object container, Object value) {
        if (value == null && container == null) {
            return true;
        }
        if (value == null || container == null) {
            return false;
        }
        if (container instanceof Pattern) {
            return ((Pattern)container).matcher(value.toString()).matches();
        }
        if (container instanceof CharSequence) {
            return value.toString().matches(container.toString());
        }
        if (container instanceof Map) {
            if (value instanceof Map) {
                return ((Map)container).keySet().containsAll(((Map)value).keySet());
            }
            return ((Map)container).containsKey(value);
        }
        return this.collectionContains(container, value);
    }

    protected Boolean collectionContains(Object collection, Object value) {
        Object left = JexlArithmetic.arrayWrap(collection);
        if (left instanceof Collection) {
            Object right = JexlArithmetic.arrayWrap(value);
            if (right instanceof Collection) {
                return ((Collection)left).containsAll((Collection)right);
            }
            return ((Collection)left).contains(value);
        }
        return null;
    }

    private static Object arrayWrap(Object container) {
        return container.getClass().isArray() ? new ArrayListWrapper(container) : container;
    }

    public Boolean endsWith(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof CharSequence) {
            return this.toString(left).endsWith(this.toString(right));
        }
        return null;
    }

    public Boolean startsWith(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof CharSequence) {
            return this.toString(left).startsWith(this.toString(right));
        }
        return null;
    }

    public Boolean empty(Object object) {
        return object == null || this.isEmpty(object, false) != false;
    }

    public Boolean isEmpty(Object object) {
        return this.isEmpty(object, object == null);
    }

    public Boolean isEmpty(Object object, Boolean def) {
        if (object != null) {
            if (object instanceof Number) {
                double d = ((Number)object).doubleValue();
                return Double.isNaN(d) || d == 0.0;
            }
            if (object instanceof CharSequence) {
                return ((CharSequence)object).length() == 0;
            }
            if (object.getClass().isArray()) {
                return Array.getLength(object) == 0;
            }
            if (object instanceof Collection) {
                return ((Collection)object).isEmpty();
            }
            if (object instanceof Map) {
                return ((Map)object).isEmpty();
            }
        }
        return def;
    }

    public Integer size(Object object) {
        return this.size(object, object == null ? 0 : 1);
    }

    public Integer size(Object object, Integer def) {
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length();
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        return def;
    }

    public Object and(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toLong(right);
        return l & r;
    }

    public Object or(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toLong(right);
        return l | r;
    }

    public Object xor(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toLong(right);
        return l ^ r;
    }

    public Object complement(Object val) {
        boolean strictCast = this.isStrict(JexlOperator.COMPLEMENT);
        long l = this.toLong(strictCast, val);
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public Object not(Object val) {
        boolean strictCast = this.isStrict(JexlOperator.NOT);
        return !this.toBoolean(strictCast, val);
    }

    public Object shiftLeft(Object left, Object right) {
        long l = this.toLong(left);
        int r = this.toInteger(right);
        return l << r;
    }

    public Object shiftRight(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toInteger(right);
        return l >> (int)r;
    }

    public Object shiftRightUnsigned(Object left, Object right) {
        long l = this.toLong(left);
        long r = this.toInteger(right);
        return l >>> (int)r;
    }

    @Deprecated
    protected int compare(Object left, Object right, String symbol) {
        JexlOperator operator;
        try {
            operator = JexlOperator.valueOf(symbol);
        }
        catch (IllegalArgumentException xill) {
            operator = JexlOperator.EQ;
        }
        return this.doCompare(left, right, operator);
    }

    private static boolean computeCompare321(JexlArithmetic arithmetic) {
        Class<?> arithmeticClass = arithmetic.getClass();
        while (arithmeticClass != JexlArithmetic.class) {
            try {
                Method cmp = arithmeticClass.getDeclaredMethod("compare", Object.class, Object.class, String.class);
                if (cmp.getDeclaringClass() == JexlArithmetic.class) continue;
                return true;
            }
            catch (NoSuchMethodException xany) {
                arithmeticClass = arithmeticClass.getSuperclass();
            }
        }
        return false;
    }

    protected int compare(Object left, Object right, JexlOperator operator) {
        return this.compare321 ? this.compare(left, right, operator.toString()) : this.doCompare(left, right, operator);
    }

    private int doCompare(Object left, Object right, JexlOperator operator) {
        boolean strictCast = this.isStrict(operator);
        if (left != null && right != null) {
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = this.toBigDecimal(strictCast, left);
                BigDecimal r = this.toBigDecimal(strictCast, right);
                return l.compareTo(r);
            }
            if (left instanceof BigInteger || right instanceof BigInteger) {
                try {
                    BigInteger l = this.toBigInteger(strictCast, left);
                    BigInteger r = this.toBigInteger(strictCast, right);
                    return l.compareTo(r);
                }
                catch (ArithmeticException l) {
                    // empty catch block
                }
            }
            if (this.isFloatingPoint(left) || this.isFloatingPoint(right)) {
                double lhs = this.toDouble(strictCast, left);
                double rhs = this.toDouble(strictCast, right);
                if (Double.isNaN(lhs)) {
                    if (Double.isNaN(rhs)) {
                        return 0;
                    }
                    return -1;
                }
                if (Double.isNaN(rhs)) {
                    return 1;
                }
                return Double.compare(lhs, rhs);
            }
            if (this.isNumberable(left) || this.isNumberable(right)) {
                try {
                    long lhs = this.toLong(strictCast, left);
                    long rhs = this.toLong(strictCast, right);
                    return Long.compare(lhs, rhs);
                }
                catch (ArithmeticException lhs) {
                    // empty catch block
                }
            }
            if (left instanceof String || right instanceof String) {
                return this.toString(left).compareTo(this.toString(right));
            }
            if (JexlOperator.EQ == operator) {
                return left.equals(right) ? 0 : -1;
            }
            if (left instanceof Comparable) {
                Comparable comparable = (Comparable)left;
                return comparable.compareTo(right);
            }
        }
        throw new ArithmeticException("Object comparison:(" + left + " " + (Object)((Object)operator) + " " + right + ")");
    }

    public boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        boolean strictCast = this.isStrict(JexlOperator.EQ);
        if (left instanceof Boolean || right instanceof Boolean) {
            return this.toBoolean(left) == this.toBoolean(strictCast, right);
        }
        return this.compare(left, right, JexlOperator.EQ) == 0;
    }

    public boolean lessThan(Object left, Object right) {
        if (left == right || left == null || right == null) {
            return false;
        }
        return this.compare(left, right, JexlOperator.LT) < 0;
    }

    public boolean greaterThan(Object left, Object right) {
        if (left == right || left == null || right == null) {
            return false;
        }
        return this.compare(left, right, JexlOperator.GT) > 0;
    }

    public boolean lessThanOrEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return this.compare(left, right, JexlOperator.LTE) <= 0;
    }

    public boolean greaterThanOrEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return this.compare(left, right, JexlOperator.GTE) >= 0;
    }

    private double parseDouble(String arg) throws ArithmeticException {
        try {
            return arg.isEmpty() ? Double.NaN : Double.parseDouble(arg);
        }
        catch (NumberFormatException e2) {
            ArithmeticException arithmeticException = new ArithmeticException("Double coercion: (" + arg + ")");
            arithmeticException.initCause(e2);
            throw arithmeticException;
        }
    }

    private long parseLong(String arg) throws ArithmeticException {
        double d = this.parseDouble(arg);
        if (Double.isNaN(d)) {
            return 0L;
        }
        double f2 = StrictMath.floor(d);
        if (d == f2) {
            return (long)d;
        }
        throw new ArithmeticException("Long coercion: (" + arg + ")");
    }

    private int parseInteger(String arg) throws ArithmeticException {
        long l = this.parseLong(arg);
        int i = (int)l;
        if ((long)i == l) {
            return i;
        }
        throw new ArithmeticException("Int coercion: (" + arg + ")");
    }

    private BigInteger parseBigInteger(String arg) throws ArithmeticException {
        if (arg.isEmpty()) {
            return BigInteger.ZERO;
        }
        try {
            return new BigInteger(arg);
        }
        catch (NumberFormatException numberFormatException) {
            return BigInteger.valueOf(this.parseLong(arg));
        }
    }

    @Deprecated
    public final Object bitwiseAnd(Object lhs, Object rhs) {
        return this.and(lhs, rhs);
    }

    @Deprecated
    public final Object bitwiseOr(Object lhs, Object rhs) {
        return this.or(lhs, rhs);
    }

    @Deprecated
    public final Object bitwiseXor(Object lhs, Object rhs) {
        return this.xor(lhs, rhs);
    }

    @Deprecated
    public final Object logicalNot(Object arg) {
        return this.not(arg);
    }

    @Deprecated
    public final Object matches(Object lhs, Object rhs) {
        return this.contains(rhs, lhs);
    }

    public static interface MapBuilder {
        public void put(Object var1, Object var2);

        public Object create();
    }

    public static interface SetBuilder {
        public void add(Object var1);

        public Object create();
    }

    public static interface ArrayBuilder {
        public void add(Object var1);

        public Object create(boolean var1);
    }

    public static interface Uberspect {
        public boolean overloads(JexlOperator var1);

        public JexlMethod getOperator(JexlOperator var1, Object ... var2);
    }

    public static class NullOperand
    extends ArithmeticException {
        private static final long serialVersionUID = 4720876194840764770L;
    }
}

