/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.optifine.CustomSkyLayer;
import net.optifine.render.Blender;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;

public class CustomSky {
    public static CustomSkyLayer[][] worldSkyLayers = null;

    public static void reset() {
        worldSkyLayers = null;
    }

    public static void update() {
        CustomSky.reset();
        if (!Config.isCustomSky()) {
            return;
        }
        worldSkyLayers = CustomSky.readCustomSkies();
    }

    public static CustomSkyLayer[][] readCustomSkies() {
        CustomSkyLayer[][] wsls = new CustomSkyLayer[10][0];
        String prefix = "mcpatcher/sky/world";
        int lastWorldId = -1;
        for (int w = 0; w < wsls.length; ++w) {
            String worldPrefix = prefix + w + "/sky";
            ArrayList<CustomSkyLayer> listSkyLayers = new ArrayList<CustomSkyLayer>();
            for (int i = 1; i < 1000; ++i) {
                String path = worldPrefix + i + ".properties";
                try {
                    ResourceLocation locPath = new ResourceLocation(path);
                    InputStream in = Config.getResourceStream((ResourceLocation)locPath);
                    if (in == null) break;
                    PropertiesOrdered props = new PropertiesOrdered();
                    props.load(in);
                    in.close();
                    Config.dbg("CustomSky properties: " + path);
                    String defSource = worldPrefix + i + ".png";
                    CustomSkyLayer sl = new CustomSkyLayer(props, defSource);
                    if (!sl.isValid(path)) continue;
                    ResourceLocation locSource = new ResourceLocation(sl.source);
                    ITextureObject tex = TextureUtils.getTexture((ResourceLocation)locSource);
                    if (tex == null) {
                        Config.log("CustomSky: Texture not found: " + locSource);
                        continue;
                    }
                    sl.textureId = tex.getGlTextureId();
                    listSkyLayers.add(sl);
                    in.close();
                    continue;
                }
                catch (FileNotFoundException e) {
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (listSkyLayers.size() <= 0) continue;
            CustomSkyLayer[] sls = listSkyLayers.toArray(new CustomSkyLayer[listSkyLayers.size()]);
            wsls[w] = sls;
            lastWorldId = w;
        }
        if (lastWorldId < 0) {
            return null;
        }
        int worldCount = lastWorldId + 1;
        CustomSkyLayer[][] wslsTrim = new CustomSkyLayer[worldCount][0];
        for (int i = 0; i < wslsTrim.length; ++i) {
            wslsTrim[i] = wsls[i];
        }
        return wslsTrim;
    }

    public static void renderSky(World world, TextureManager re, float partialTicks) {
        if (worldSkyLayers == null) {
            return;
        }
        int dimId = world.provider.getDimensionType().getId();
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return;
        }
        long time = world.getWorldTime();
        int timeOfDay = (int)(time % 24000L);
        float celestialAngle = world.getCelestialAngle(partialTicks);
        float rainStrength = world.getRainStrength(partialTicks);
        float thunderStrength = world.getThunderStrength(partialTicks);
        if (rainStrength > 0.0f) {
            thunderStrength /= rainStrength;
        }
        for (int i = 0; i < sls.length; ++i) {
            CustomSkyLayer sl = sls[i];
            if (!sl.isActive(world, timeOfDay)) continue;
            sl.render(world, timeOfDay, celestialAngle, rainStrength, thunderStrength);
        }
        float rainBrightness = 1.0f - rainStrength;
        Blender.clearBlend(rainBrightness);
    }

    public static boolean hasSkyLayers(World world) {
        if (worldSkyLayers == null) {
            return false;
        }
        int dimId = world.provider.getDimensionType().getId();
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return false;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return false;
        }
        return sls.length > 0;
    }
}

