/*
 * Decompiled with CFR 0.152.
 */
package org.teamderpy.shouldersurfing.util;

import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.teamderpy.shouldersurfing.config.Config;
import org.teamderpy.shouldersurfing.config.Perspective;
import org.teamderpy.shouldersurfing.util.ShoulderState;

@SideOnly(value=Side.CLIENT)
public class ShoulderSurfingHelper {
    public static double cameraDistance(World world, double distance, float yaw, float pitch) {
        Vec3d view = Minecraft.func_71410_x().func_175606_aa().func_174824_e(Minecraft.func_71410_x().func_184121_ak());
        Vec3d cameraOffset = ShoulderSurfingHelper.cameraOffset(distance, yaw, pitch);
        for (int i2 = 0; i2 < 8; ++i2) {
            double newDistance;
            Vec3d camera;
            Vec3d offset = new Vec3d((double)(i2 & 1), (double)(i2 >> 1 & 1), (double)(i2 >> 2 & 1)).func_186678_a(2.0).func_178786_a(1.0, 1.0, 1.0).func_186678_a(0.1);
            Vec3d head = view.func_178787_e(offset);
            RayTraceResult result = world.func_147447_a(head, camera = head.func_178787_e(cameraOffset), false, true, false);
            if (result == null || !((newDistance = result.field_72307_f.func_72438_d(view)) < distance)) continue;
            distance = newDistance;
        }
        return distance;
    }

    public static Map.Entry<Vec3d, Vec3d> shoulderSurfingLook(Entity entity, float partialTicks, double distanceSq) {
        Vec3d cameraOffset = ShoulderSurfingHelper.cameraOffset(ShoulderState.getCameraDistance(), entity.field_70177_z, entity.field_70125_A);
        Vec3d offset = ShoulderSurfingHelper.rayTraceHeadOffset(cameraOffset);
        Vec3d start = entity.func_174824_e(partialTicks).func_178787_e(cameraOffset);
        Vec3d look = entity.func_70676_i(partialTicks);
        double length = offset.func_72433_c();
        length *= length;
        if (Config.CLIENT.limitPlayerReach() && length < distanceSq) {
            distanceSq -= length;
        }
        double distance = (double)MathHelper.func_76133_a((double)distanceSq) + cameraOffset.func_72438_d(offset);
        Vec3d end = start.func_178787_e(look.func_186678_a(distance));
        return new AbstractMap.SimpleEntry<Vec3d, Vec3d>(start, end);
    }

    public static Vec3d cameraOffset(double distance, float yaw, float pitch) {
        return new Vec3d(Config.CLIENT.getOffsetX(), Config.CLIENT.getOffsetY(), -Config.CLIENT.getOffsetZ()).func_178789_a((float)Math.toRadians(-pitch)).func_178785_b((float)Math.toRadians(-yaw)).func_72432_b().func_186678_a(distance);
    }

    public static Vec3d rayTraceHeadOffset(Vec3d cameraOffset) {
        Vec3d view = Minecraft.func_71410_x().func_175606_aa().func_70040_Z();
        return ShoulderSurfingHelper.lineIntersection(Vec3d.field_186680_a, view, cameraOffset, view);
    }

    public static Vec3d lineIntersection(Vec3d planePoint, Vec3d planeNormal, Vec3d linePoint, Vec3d lineNormal) {
        double distance = (planeNormal.func_72430_b(planePoint) - planeNormal.func_72430_b(linePoint)) / planeNormal.func_72430_b(lineNormal);
        return linePoint.func_178787_e(lineNormal.func_186678_a(distance));
    }

    public static void setPerspective(Perspective perspective) {
        Minecraft.func_71410_x().field_71474_y.field_74320_O = perspective.getPointOfView();
    }
}

