/*
 * Decompiled with CFR 0.152.
 */
package org.teamderpy.shouldersurfing.config;

import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.teamderpy.shouldersurfing.config.Config;

@SideOnly(value=Side.CLIENT)
public enum Perspective {
    FIRST_PERSON(0),
    THIRD_PERSON_FRONT(2),
    SHOULDER_SURFING(1);

    private final int pointOfView;

    private Perspective(int pointOfView) {
        this.pointOfView = pointOfView;
    }

    public int getPointOfView() {
        return this.pointOfView;
    }

    public Perspective next() {
        Perspective next = Perspective.values()[(this.ordinal() + 1) % Perspective.values().length];
        if (Config.CLIENT.replaceDefaultPerspective()) {
            if (this == FIRST_PERSON) {
                return SHOULDER_SURFING;
            }
            if (this == SHOULDER_SURFING) {
                return THIRD_PERSON_FRONT;
            }
            if (this == THIRD_PERSON_FRONT) {
                return FIRST_PERSON;
            }
        }
        return next;
    }

    public static Perspective of(int pointOfView) {
        switch (pointOfView) {
            case 0: {
                return FIRST_PERSON;
            }
            case 1: {
                return SHOULDER_SURFING;
            }
            case 2: {
                return THIRD_PERSON_FRONT;
            }
        }
        return FIRST_PERSON;
    }

    public static Perspective current() {
        return Perspective.of(Minecraft.func_71410_x().field_71474_y.field_74320_O);
    }
}

