/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Runtime;

public class Random {
    private final Xorshiro128 rnd;
    private static long seedHalf = 8020463840L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long newSeed() {
        long newSeedHalf;
        Class clazz = Random.class;
        synchronized (clazz) {
            long oldSeedHalf = seedHalf;
            seedHalf = newSeedHalf = oldSeedHalf * 3512401965023503517L;
        }
        return newSeedHalf;
    }

    public Random() {
        this(Random.newSeed() ^ System.nanoTime());
    }

    public Random(long seed) {
        this.rnd = new Xorshiro128(seed);
    }

    public float nextFloat() {
        return this.rnd.nextFloat();
    }

    public int nextInt(int n2) {
        return this.rnd.nextInt(n2);
    }

    private static final class Xorshiro128 {
        private static final float INT_TO_FLOAT = Float.intBitsToFloat(0x33800000);
        private long _s0;
        private long _s1;
        private long state;

        Xorshiro128(long seed) {
            this.state = seed;
            this._s0 = this.nextSplitMix64();
            this._s1 = this.nextSplitMix64();
        }

        private long nextSplitMix64() {
            long z2 = this.state += -7046029254386353131L;
            z2 = (z2 ^ z2 >>> 30) * -4658895280553007687L;
            z2 = (z2 ^ z2 >>> 27) * -7723592293110705685L;
            return z2 ^ z2 >>> 31;
        }

        final float nextFloat() {
            return (float)(this.nextInt() >>> 8) * INT_TO_FLOAT;
        }

        private int nextInt() {
            long s0 = this._s0;
            long s1 = this._s1;
            long result = s0 + s1;
            this.rotateLeft(s0, s1 ^= s0);
            return (int)(result & 0xFFFFFFFFFFFFFFFFL);
        }

        private static long rotl_JDK4(long x2, int k2) {
            return x2 << k2 | x2 >>> 64 - k2;
        }

        private static long rotl_JDK5(long x2, int k2) {
            return Long.rotateLeft(x2, k2);
        }

        private static long rotl(long x2, int k2) {
            if (Runtime.HAS_Long_rotateLeft) {
                return Xorshiro128.rotl_JDK5(x2, k2);
            }
            return Xorshiro128.rotl_JDK4(x2, k2);
        }

        private void rotateLeft(long s0, long s1) {
            this._s0 = Xorshiro128.rotl(s0, 55) ^ s1 ^ s1 << 14;
            this._s1 = Xorshiro128.rotl(s1, 36);
        }

        final int nextInt(int n2) {
            long r2 = this.nextInt() >>> 1;
            r2 = r2 * (long)n2 >> 31;
            return (int)r2;
        }
    }
}

