/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Math;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FrustumRayBuilder {
    private float nxnyX;
    private float nxnyY;
    private float nxnyZ;
    private float pxnyX;
    private float pxnyY;
    private float pxnyZ;
    private float pxpyX;
    private float pxpyY;
    private float pxpyZ;
    private float nxpyX;
    private float nxpyY;
    private float nxpyZ;
    private float cx;
    private float cy;
    private float cz;

    public FrustumRayBuilder() {
    }

    public FrustumRayBuilder(Matrix4fc m2) {
        this.set(m2);
    }

    public FrustumRayBuilder set(Matrix4fc m2) {
        float nxX = m2.m03() + m2.m00();
        float nxY = m2.m13() + m2.m10();
        float nxZ = m2.m23() + m2.m20();
        float d1 = m2.m33() + m2.m30();
        float pxX = m2.m03() - m2.m00();
        float pxY = m2.m13() - m2.m10();
        float pxZ = m2.m23() - m2.m20();
        float d2 = m2.m33() - m2.m30();
        float nyX = m2.m03() + m2.m01();
        float nyY = m2.m13() + m2.m11();
        float nyZ = m2.m23() + m2.m21();
        float pyX = m2.m03() - m2.m01();
        float pyY = m2.m13() - m2.m11();
        float pyZ = m2.m23() - m2.m21();
        float d3 = m2.m33() - m2.m31();
        this.nxnyX = nyY * nxZ - nyZ * nxY;
        this.nxnyY = nyZ * nxX - nyX * nxZ;
        this.nxnyZ = nyX * nxY - nyY * nxX;
        this.pxnyX = pxY * nyZ - pxZ * nyY;
        this.pxnyY = pxZ * nyX - pxX * nyZ;
        this.pxnyZ = pxX * nyY - pxY * nyX;
        this.nxpyX = nxY * pyZ - nxZ * pyY;
        this.nxpyY = nxZ * pyX - nxX * pyZ;
        this.nxpyZ = nxX * pyY - nxY * pyX;
        this.pxpyX = pyY * pxZ - pyZ * pxY;
        this.pxpyY = pyZ * pxX - pyX * pxZ;
        this.pxpyZ = pyX * pxY - pyY * pxX;
        float pxnxX = pxY * nxZ - pxZ * nxY;
        float pxnxY = pxZ * nxX - pxX * nxZ;
        float pxnxZ = pxX * nxY - pxY * nxX;
        float invDot = 1.0f / (nxX * this.pxpyX + nxY * this.pxpyY + nxZ * this.pxpyZ);
        this.cx = (-this.pxpyX * d1 - this.nxpyX * d2 - pxnxX * d3) * invDot;
        this.cy = (-this.pxpyY * d1 - this.nxpyY * d2 - pxnxY * d3) * invDot;
        this.cz = (-this.pxpyZ * d1 - this.nxpyZ * d2 - pxnxZ * d3) * invDot;
        return this;
    }

    public Vector3fc origin(Vector3f origin) {
        origin.x = this.cx;
        origin.y = this.cy;
        origin.z = this.cz;
        return origin;
    }

    public Vector3fc dir(float x2, float y2, Vector3f dir) {
        float y1x = this.nxnyX + (this.nxpyX - this.nxnyX) * y2;
        float y1y = this.nxnyY + (this.nxpyY - this.nxnyY) * y2;
        float y1z = this.nxnyZ + (this.nxpyZ - this.nxnyZ) * y2;
        float y2x = this.pxnyX + (this.pxpyX - this.pxnyX) * y2;
        float y2y = this.pxnyY + (this.pxpyY - this.pxnyY) * y2;
        float y2z = this.pxnyZ + (this.pxpyZ - this.pxnyZ) * y2;
        float dx = y1x + (y2x - y1x) * x2;
        float dy = y1y + (y2y - y1y) * x2;
        float dz = y1z + (y2z - y1z) * x2;
        float invLen = Math.invsqrt(dx * dx + dy * dy + dz * dz);
        dir.x = dx * invLen;
        dir.y = dy * invLen;
        dir.z = dz * invLen;
        return dir;
    }
}

