/*
 * Decompiled with CFR 0.152.
 */
package org._blockbuster.components.rate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org._blockbuster.components.BedrockComponentBase;
import org._blockbuster.components.IComponentEmitterUpdate;
import org._blockbuster.components.rate.BedrockComponentRate;
import org._blockbuster.emitter.BedrockEmitter;
import org._blockbuster.math.Constant;
import org._blockbuster.math.Operation;
import org._blockbuster.math.molang.MolangException;
import org._blockbuster.math.molang.MolangParser;
import org._blockbuster.math.molang.expressions.MolangExpression;
import org._blockbuster.math.molang.expressions.MolangValue;

public class BedrockComponentRateInstant
extends BedrockComponentRate
implements IComponentEmitterUpdate {
    public static final MolangExpression DEFAULT_PARTICLES = new MolangValue(null, new Constant(10.0));

    public BedrockComponentRateInstant() {
        this.particles = DEFAULT_PARTICLES;
    }

    @Override
    public BedrockComponentBase fromJson(JsonElement elem, MolangParser parser) throws MolangException {
        if (!elem.isJsonObject()) {
            return super.fromJson(elem, parser);
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("num_particles")) {
            this.particles = parser.parseJson(element.get("num_particles"));
        }
        return super.fromJson((JsonElement)element, parser);
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        if (!MolangExpression.isConstant(this.particles, 10.0)) {
            object.add("num_particles", this.particles.toJson());
        }
        return object;
    }

    @Override
    public void update(BedrockEmitter emitter) {
        double age = emitter.getAge();
        if (emitter.playing && Operation.equals(age, 0.0)) {
            emitter.setEmitterVariables(0.0f);
            int c2 = (int)this.particles.get();
            for (int i2 = 0; i2 < c2; ++i2) {
                emitter.spawnParticle();
            }
        }
    }
}

