/*
 * Decompiled with CFR 0.152.
 */
package org._blockbuster.components.appearance;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.client.renderer.BufferBuilder;
import org._blockbuster.BedrockSchemeJsonAdapter;
import org._blockbuster.components.BedrockComponentBase;
import org._blockbuster.components.IComponentParticleRender;
import org._blockbuster.components.appearance.Tint;
import org._blockbuster.emitter.BedrockEmitter;
import org._blockbuster.emitter.BedrockParticle;
import org._blockbuster.math.molang.MolangException;
import org._blockbuster.math.molang.MolangParser;

public class BedrockComponentAppearanceTinting
extends BedrockComponentBase
implements IComponentParticleRender {
    public Tint color = new Tint.Solid();

    @Override
    public BedrockComponentBase fromJson(JsonElement elem, MolangParser parser) throws MolangException {
        if (!elem.isJsonObject()) {
            return super.fromJson(elem, parser);
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("color")) {
            JsonElement color = element.get("color");
            if (color.isJsonArray() || color.isJsonPrimitive()) {
                this.color = Tint.parseColor(color, parser);
            } else if (color.isJsonObject()) {
                this.color = Tint.parseGradient(color.getAsJsonObject(), parser);
            }
        }
        return super.fromJson((JsonElement)element, parser);
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        JsonElement element = this.color.toJson();
        if (!BedrockSchemeJsonAdapter.isEmpty(element)) {
            object.add("color", element);
        }
        return object;
    }

    @Override
    public void preRender(BedrockEmitter emitter, float partialTicks) {
    }

    @Override
    public void render(BedrockEmitter emitter, BedrockParticle particle, BufferBuilder builder, float partialTicks) {
        this.renderOnScreen(particle, 0, 0, 0.0f, 0.0f);
    }

    public void renderOnScreen(BedrockParticle particle, int x2, int y2, float scale, float partialTicks) {
        if (this.color != null) {
            this.color.compute(particle);
        } else {
            particle.a = 1.0f;
            particle.b = 1.0f;
            particle.g = 1.0f;
            particle.r = 1.0f;
        }
    }

    @Override
    public void postRender(BedrockEmitter emitter, float partialTicks) {
    }

    @Override
    public int getSortingIndex() {
        return -10;
    }
}

