/*
 * Decompiled with CFR 0.152.
 */
package org._blockbuster;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Map;
import org._blockbuster.BedrockCurve;
import org._blockbuster.BedrockMaterial;
import org._blockbuster.BedrockScheme;
import org._blockbuster.components.BedrockComponentBase;
import org._blockbuster.components.appearance.BedrockComponentAppearanceBillboard;
import org._blockbuster.components.appearance.BedrockComponentAppearanceLighting;
import org._blockbuster.components.appearance.BedrockComponentAppearanceTinting;
import org._blockbuster.components.expiration.BedrockComponentExpireInBlocks;
import org._blockbuster.components.expiration.BedrockComponentExpireNotInBlocks;
import org._blockbuster.components.expiration.BedrockComponentKillPlane;
import org._blockbuster.components.expiration.BedrockComponentParticleLifetime;
import org._blockbuster.components.lifetime.BedrockComponentLifetimeExpression;
import org._blockbuster.components.lifetime.BedrockComponentLifetimeLooping;
import org._blockbuster.components.lifetime.BedrockComponentLifetimeOnce;
import org._blockbuster.components.meta.BedrockComponentInitialization;
import org._blockbuster.components.meta.BedrockComponentLocalSpace;
import org._blockbuster.components.motion.BedrockComponentInitialSpeed;
import org._blockbuster.components.motion.BedrockComponentInitialSpin;
import org._blockbuster.components.motion.BedrockComponentMotionCollision;
import org._blockbuster.components.motion.BedrockComponentMotionDynamic;
import org._blockbuster.components.motion.BedrockComponentMotionParametric;
import org._blockbuster.components.rate.BedrockComponentRateInstant;
import org._blockbuster.components.rate.BedrockComponentRateSteady;
import org._blockbuster.components.shape.BedrockComponentShapeBox;
import org._blockbuster.components.shape.BedrockComponentShapeDisc;
import org._blockbuster.components.shape.BedrockComponentShapeEntityAABB;
import org._blockbuster.components.shape.BedrockComponentShapePoint;
import org._blockbuster.components.shape.BedrockComponentShapeSphere;
import org._blockbuster.math.Operation;
import org._blockbuster.math.molang.MolangException;

public class BedrockSchemeJsonAdapter
implements JsonDeserializer<BedrockScheme> {
    public BiMap<String, Class<? extends BedrockComponentBase>> components = HashBiMap.create();

    public static boolean isEmpty(JsonElement element) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray().size() == 0;
        }
        if (element.isJsonObject()) {
            return element.getAsJsonObject().size() == 0;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return primitive.getAsString().isEmpty();
            }
            if (primitive.isNumber()) {
                return Operation.equals(primitive.getAsDouble(), 0.0);
            }
        }
        return element.isJsonNull();
    }

    public BedrockSchemeJsonAdapter() {
        this.components.put((Object)"minecraft:emitter_local_space", BedrockComponentLocalSpace.class);
        this.components.put((Object)"minecraft:emitter_initialization", BedrockComponentInitialization.class);
        this.components.put((Object)"minecraft:emitter_rate_instant", BedrockComponentRateInstant.class);
        this.components.put((Object)"minecraft:emitter_rate_steady", BedrockComponentRateSteady.class);
        this.components.put((Object)"minecraft:emitter_lifetime_looping", BedrockComponentLifetimeLooping.class);
        this.components.put((Object)"minecraft:emitter_lifetime_once", BedrockComponentLifetimeOnce.class);
        this.components.put((Object)"minecraft:emitter_lifetime_expression", BedrockComponentLifetimeExpression.class);
        this.components.put((Object)"minecraft:emitter_shape_disc", BedrockComponentShapeDisc.class);
        this.components.put((Object)"minecraft:emitter_shape_box", BedrockComponentShapeBox.class);
        this.components.put((Object)"minecraft:emitter_shape_entity_aabb", BedrockComponentShapeEntityAABB.class);
        this.components.put((Object)"minecraft:emitter_shape_point", BedrockComponentShapePoint.class);
        this.components.put((Object)"minecraft:emitter_shape_sphere", BedrockComponentShapeSphere.class);
        this.components.put((Object)"minecraft:particle_lifetime_expression", BedrockComponentParticleLifetime.class);
        this.components.put((Object)"minecraft:particle_expire_if_in_blocks", BedrockComponentExpireInBlocks.class);
        this.components.put((Object)"minecraft:particle_expire_if_not_in_blocks", BedrockComponentExpireNotInBlocks.class);
        this.components.put((Object)"minecraft:particle_kill_plane", BedrockComponentKillPlane.class);
        this.components.put((Object)"minecraft:particle_appearance_billboard", BedrockComponentAppearanceBillboard.class);
        this.components.put((Object)"minecraft:particle_appearance_lighting", BedrockComponentAppearanceLighting.class);
        this.components.put((Object)"minecraft:particle_appearance_tinting", BedrockComponentAppearanceTinting.class);
        this.components.put((Object)"minecraft:particle_initial_speed", BedrockComponentInitialSpeed.class);
        this.components.put((Object)"minecraft:particle_initial_spin", BedrockComponentInitialSpin.class);
        this.components.put((Object)"minecraft:particle_motion_collision", BedrockComponentMotionCollision.class);
        this.components.put((Object)"minecraft:particle_motion_dynamic", BedrockComponentMotionDynamic.class);
        this.components.put((Object)"minecraft:particle_motion_parametric", BedrockComponentMotionParametric.class);
    }

    public BedrockScheme deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BedrockScheme scheme = new BedrockScheme();
        if (!json.isJsonObject()) {
            throw new JsonParseException("The root element of Bedrock particle should be an object!");
        }
        JsonObject root = json.getAsJsonObject();
        try {
            this.parseEffect(scheme, this.getObject(root, "particle_effect", "No particle_effect was found..."));
        }
        catch (MolangException e2) {
            throw new JsonParseException("Couldn't parse some MoLang expression!", (Throwable)e2);
        }
        scheme.setup();
        return scheme;
    }

    private void parseEffect(BedrockScheme scheme, JsonObject effect) throws JsonParseException, MolangException {
        JsonElement curves;
        this.parseDescription(scheme, this.getObject(effect, "description", "No particle_effect.description was found..."));
        if (effect.has("curves") && (curves = effect.get("curves")).isJsonObject()) {
            this.parseCurves(scheme, curves.getAsJsonObject());
        }
        this.parseComponents(scheme, this.getObject(effect, "components", "No particle_effect.components was found..."));
    }

    private void parseDescription(BedrockScheme scheme, JsonObject description) throws JsonParseException {
        String texture;
        JsonObject parameters;
        if (description.has("identifier")) {
            scheme.identifier = description.get("identifier").getAsString();
        }
        if ((parameters = this.getObject(description, "basic_render_parameters", "No particle_effect.basic_render_parameters was found...")).has("material")) {
            scheme.material = BedrockMaterial.fromString(parameters.get("material").getAsString());
        }
        if (parameters.has("texture") && !(texture = parameters.get("texture").getAsString()).equals("textures/particle/particles")) {
            scheme.textureStr = texture;
        }
    }

    private void parseCurves(BedrockScheme scheme, JsonObject curves) throws MolangException {
        for (Map.Entry entry : curves.entrySet()) {
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonObject()) continue;
            BedrockCurve curve = new BedrockCurve();
            curve.fromJson(element.getAsJsonObject(), scheme.parser);
            scheme.curves.put((String)entry.getKey(), curve);
        }
    }

    private void parseComponents(BedrockScheme scheme, JsonObject components) throws MolangException {
        for (Map.Entry entry : components.entrySet()) {
            String key = (String)entry.getKey();
            if (!this.components.containsKey((Object)key)) continue;
            BedrockComponentBase component = null;
            try {
                component = (BedrockComponentBase)((Class)this.components.get((Object)key)).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (component != null) {
                component.fromJson((JsonElement)entry.getValue(), scheme.parser);
                scheme.components.add(component);
                continue;
            }
            System.out.println("Failed to parse given component " + key + " in " + scheme.identifier + "!");
        }
    }

    private JsonObject getObject(JsonObject object, String key, String message) throws JsonParseException {
        if (!object.has(key) && !object.get(key).isJsonObject()) {
            throw new JsonParseException(message);
        }
        return object.get(key).getAsJsonObject();
    }
}

