/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded.videosurface;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import uk.co.caprica.vlcj.binding.Kernel32;
import uk.co.caprica.vlcj.binding.LibC;
import uk.co.caprica.vlcj.binding.RuntimeUtil;
import uk.co.caprica.vlcj.binding.support.size_t;
import uk.co.caprica.vlcj.player.embedded.videosurface.ByteBufferFactory;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;

final class NativeBuffers {
    private final boolean lockBuffers;
    private ByteBuffer[] nativeBuffers;
    private Pointer[] pointers;

    NativeBuffers(boolean lockBuffers) {
        this.lockBuffers = lockBuffers;
    }

    int allocate(BufferFormat bufferFormat) {
        int planeCount = bufferFormat.getPlaneCount();
        int[] pitchValues = bufferFormat.getPitches();
        int[] lineValues = bufferFormat.getLines();
        this.nativeBuffers = new ByteBuffer[planeCount];
        this.pointers = new Pointer[planeCount];
        for (int i2 = 0; i2 < planeCount; ++i2) {
            ByteBuffer buffer;
            this.nativeBuffers[i2] = buffer = ByteBufferFactory.allocateAlignedBuffer(pitchValues[i2] * lineValues[i2]);
            this.pointers[i2] = Pointer.createConstant(ByteBufferFactory.getAddress(buffer));
            if (!this.lockBuffers) continue;
            if (!RuntimeUtil.isWindows()) {
                LibC.INSTANCE.mlock(this.pointers[i2], new NativeLong((long)buffer.capacity()));
                continue;
            }
            Kernel32.INSTANCE.VirtualLock(this.pointers[i2], new size_t((long)buffer.capacity()));
        }
        return this.nativeBuffers.length;
    }

    void free() {
        if (this.nativeBuffers != null) {
            if (this.lockBuffers) {
                for (int i2 = 0; i2 < this.nativeBuffers.length; ++i2) {
                    if (!RuntimeUtil.isWindows()) {
                        LibC.INSTANCE.munlock(this.pointers[i2], new NativeLong((long)this.nativeBuffers[i2].capacity()));
                        continue;
                    }
                    Kernel32.INSTANCE.VirtualUnlock(this.pointers[i2], new size_t((long)this.nativeBuffers[i2].capacity()));
                }
            }
            this.nativeBuffers = null;
            this.pointers = null;
        }
    }

    ByteBuffer[] buffers() {
        return this.nativeBuffers;
    }

    Pointer[] pointers() {
        return this.pointers;
    }
}

