/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.embedded;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import uk.co.caprica.vlcj.player.embedded.BaseApi;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.ComponentVideoSurface;

public final class OverlayApi
extends BaseApi {
    private final OverlayComponentAdapter overlayComponentAdapter = new OverlayComponentAdapter();
    private final OverlayWindowAdapter overlayWindowAdapter = new OverlayWindowAdapter();
    private final Rectangle bounds = new Rectangle();
    private Window overlay;
    private boolean requestedOverlay;
    private boolean restoreOverlay;

    OverlayApi(EmbeddedMediaPlayer mediaPlayer) {
        super(mediaPlayer);
    }

    public Window get() {
        return this.overlay;
    }

    public void set(Window overlay) {
        if (!(this.mediaPlayer.videoSurface().getVideoSurface() instanceof ComponentVideoSurface)) {
            throw new IllegalStateException("Overlay requires a ComponentVideoSurface");
        }
        this.enable(false);
        this.removeOverlay();
        this.addOverlay(overlay);
    }

    public void enable(boolean enable) {
        this.requestedOverlay = enable;
        if (this.overlay != null) {
            if (enable) {
                if (!this.overlay.isVisible()) {
                    Component component = this.getComponent();
                    component.getBounds(this.bounds);
                    this.bounds.setLocation(component.getLocationOnScreen());
                    this.overlay.setBounds(this.bounds);
                    Window window = this.getAncestorWindow(component);
                    window.addComponentListener(this.overlayComponentAdapter);
                    this.overlay.setVisible(true);
                }
            } else if (this.overlay.isVisible()) {
                this.overlay.setVisible(false);
                Window window = this.getAncestorWindow(this.getComponent());
                window.removeComponentListener(this.overlayComponentAdapter);
            }
        }
    }

    public boolean enabled() {
        return this.overlay != null && this.overlay.isVisible();
    }

    private void addOverlay(Window overlay) {
        if (overlay != null) {
            this.overlay = overlay;
            Window window = this.getAncestorWindow(this.getComponent());
            if (window != null) {
                window.addWindowListener(this.overlayWindowAdapter);
            }
        }
    }

    private void removeOverlay() {
        if (this.overlay != null) {
            Window window = this.getAncestorWindow(this.getComponent());
            window.removeWindowListener(this.overlayWindowAdapter);
            this.overlay = null;
        }
    }

    private void showOverlay() {
        if (this.restoreOverlay) {
            this.enable(true);
        }
    }

    private void hideOverlay() {
        if (this.requestedOverlay) {
            this.restoreOverlay = true;
            this.enable(false);
        } else {
            this.restoreOverlay = false;
        }
    }

    private Component getComponent() {
        return ((ComponentVideoSurface)this.mediaPlayer.videoSurface().getVideoSurface()).component();
    }

    private Window getAncestorWindow(Component component) {
        return (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
    }

    private final class OverlayWindowAdapter
    extends WindowAdapter {
        private OverlayWindowAdapter() {
        }

        @Override
        public void windowIconified(WindowEvent e2) {
        }

        @Override
        public void windowDeiconified(WindowEvent e2) {
            OverlayApi.this.showOverlay();
        }

        @Override
        public void windowDeactivated(WindowEvent e2) {
            OverlayApi.this.hideOverlay();
        }

        @Override
        public void windowActivated(WindowEvent e2) {
            OverlayApi.this.showOverlay();
        }
    }

    private final class OverlayComponentAdapter
    extends ComponentAdapter {
        private OverlayComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e2) {
            OverlayApi.this.overlay.setSize(OverlayApi.this.getComponent().getSize());
        }

        @Override
        public void componentMoved(ComponentEvent e2) {
            OverlayApi.this.overlay.setLocation(OverlayApi.this.getComponent().getLocationOnScreen());
        }

        @Override
        public void componentShown(ComponentEvent e2) {
            OverlayApi.this.showOverlay();
        }

        @Override
        public void componentHidden(ComponentEvent e2) {
            OverlayApi.this.hideOverlay();
        }
    }
}

