/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.media;

public abstract class TrackInfo {
    private final int codec;
    private final String codecName;
    private final int originalCodec;
    private final String originalCodecName;
    private final int id;
    private final int profile;
    private final int level;
    private final int bitRate;
    private final String language;
    private final String description;
    private final String codecDescription;

    protected TrackInfo(int codec, int originalCodec, int id2, int profile, int level, int bitRate, String language, String description, String codecDescription) {
        this.codec = codec;
        this.codecName = this.codecName(codec);
        this.originalCodec = originalCodec;
        this.originalCodecName = this.codecName(originalCodec);
        this.id = id2;
        this.profile = profile;
        this.level = level;
        this.bitRate = bitRate;
        this.language = language;
        this.description = description;
        this.codecDescription = codecDescription;
    }

    public final int codec() {
        return this.codec;
    }

    public final String codecName() {
        return this.codecName;
    }

    public final int orignalCodec() {
        return this.codec;
    }

    public final String originalCodecName() {
        return this.originalCodecName;
    }

    public final int id() {
        return this.id;
    }

    public final int profile() {
        return this.profile;
    }

    public final int level() {
        return this.level;
    }

    public final int bitRate() {
        return this.bitRate;
    }

    public final String language() {
        return this.language;
    }

    public final String description() {
        return this.description;
    }

    public final String codecDescription() {
        return this.codecDescription;
    }

    public String toString() {
        StringBuilder sb2 = new StringBuilder(100);
        sb2.append(this.getClass().getSimpleName()).append('[');
        sb2.append("codec=0x").append(Integer.toHexString(this.codec)).append(',');
        sb2.append("codecName=").append(this.codecName).append(',');
        sb2.append("originalCodec=0x").append(Integer.toHexString(this.originalCodec)).append(',');
        sb2.append("originalCodecName=").append(this.originalCodecName).append(',');
        sb2.append("id=").append(this.id).append(',');
        sb2.append("profile=").append(this.profile).append(',');
        sb2.append("level=").append(this.level).append(',');
        sb2.append("bitRate=").append(this.bitRate).append(',');
        sb2.append("language=").append(this.language).append(',');
        sb2.append("description=").append(this.description).append(',');
        sb2.append("codecDescription=").append(this.codecDescription).append(']');
        return sb2.toString();
    }

    private String codecName(int codec) {
        return codec != 0 ? new String(new byte[]{(byte)codec, (byte)(codec >>> 8), (byte)(codec >>> 16), (byte)(codec >>> 24)}).trim() : null;
    }
}

