/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery.strategy;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.co.caprica.vlcj.factory.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;

public abstract class BaseNativeDiscoveryStrategy
implements NativeDiscoveryStrategy {
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private final Pattern[] patternsToMatch;
    private final String[] pluginPathFormats;

    public BaseNativeDiscoveryStrategy(String[] filenamePatterns, String[] pluginPathFormats) {
        this.patternsToMatch = new Pattern[filenamePatterns.length];
        for (int i2 = 0; i2 < filenamePatterns.length; ++i2) {
            this.patternsToMatch[i2] = Pattern.compile(filenamePatterns[i2]);
        }
        this.pluginPathFormats = pluginPathFormats;
    }

    @Override
    public final String discover() {
        for (String discoveryDirectory : this.discoveryDirectories()) {
            NativeDiscovery.LOGGER.info(NativeDiscovery.IT, "Searching on '{}'", (Object)discoveryDirectory);
            if (!this.find(discoveryDirectory)) continue;
            return discoveryDirectory;
        }
        return null;
    }

    protected abstract List<String> discoveryDirectories();

    private boolean find(String directoryName) {
        File dir = new File(directoryName);
        if (!dir.exists()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            HashSet<String> matches = new HashSet<String>(this.patternsToMatch.length);
            for (File file : files) {
                for (Pattern pattern : this.patternsToMatch) {
                    Matcher matcher = pattern.matcher(file.getName());
                    if (!matcher.matches()) continue;
                    matches.add(pattern.pattern());
                    if (matches.size() != this.patternsToMatch.length) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean onFound(String path) {
        return true;
    }

    @Override
    public final boolean onSetPluginPath(String path) {
        for (String pathFormat : this.pluginPathFormats) {
            String pluginPath = String.format(pathFormat, path);
            if (!new File(pluginPath).exists()) continue;
            return this.setPluginPath(pluginPath);
        }
        return false;
    }

    protected abstract boolean setPluginPath(String var1);
}

