/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.co.caprica.vlcj.factory.discovery.provider.ConfigurationFileDiscoveryDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.CustomDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.DiscoveryDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.JnaLibraryPathDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.LinuxWellKnownDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.OsxWellKnownDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.SystemPathDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.UserDirDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.WindowsInstallDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.strategy.BaseNativeDiscoveryStrategy;

public abstract class DirectoryProviderDiscoveryStrategy
extends BaseNativeDiscoveryStrategy {
    public DirectoryProviderDiscoveryStrategy(String[] filenamePatterns, String[] pluginPathFormats) {
        super(filenamePatterns, pluginPathFormats);
    }

    @Override
    public final List<String> discoveryDirectories() {
        ArrayList<String> directories = new ArrayList<String>();
        for (DiscoveryDirectoryProvider provider : this.getSupportedProviders()) {
            directories.addAll(Arrays.asList(provider.directories()));
        }
        return directories;
    }

    private List<DiscoveryDirectoryProvider> getSupportedProviders() {
        DiscoveryDirectoryProvider[] directoryProviders;
        ArrayList<DiscoveryDirectoryProvider> result = new ArrayList<DiscoveryDirectoryProvider>();
        for (DiscoveryDirectoryProvider service : directoryProviders = new DiscoveryDirectoryProvider[]{new CustomDirectoryProvider(), new ConfigurationFileDiscoveryDirectoryProvider(), new JnaLibraryPathDirectoryProvider(), new LinuxWellKnownDirectoryProvider(), new OsxWellKnownDirectoryProvider(), new SystemPathDirectoryProvider(), new UserDirDirectoryProvider(), new WindowsInstallDirectoryProvider()}) {
            if (!service.supported()) continue;
            result.add(service);
        }
        return this.sort(result);
    }

    private List<DiscoveryDirectoryProvider> sort(List<DiscoveryDirectoryProvider> providers) {
        providers.sort((p1, p2) -> p2.priority() - p1.priority());
        return providers;
    }
}

