/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery.provider;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import uk.co.caprica.vlcj.factory.discovery.provider.DiscoveryDirectoryProvider;

public class ConfigurationFileDiscoveryDirectoryProvider
implements DiscoveryDirectoryProvider {
    private static final String CONFIG_DIR = System.getProperty("user.home") + "/.config/vlcj";
    private static final String CONFIG_FILE_NAME = "vlcj.config";
    private static final String PROPERTY_NAME = "nativeDirectory";

    @Override
    public int priority() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] directories() {
        Reader reader = null;
        try {
            File configurationFile = ConfigurationFileDiscoveryDirectoryProvider.getConfigurationFile();
            Properties properties = new Properties();
            reader = new FileReader(configurationFile);
            properties.load(reader);
            String directory = properties.getProperty(PROPERTY_NAME);
            if (directory != null) {
                String[] stringArray = new String[]{directory};
                return stringArray;
            }
        }
        catch (FileNotFoundException configurationFile) {
        }
        catch (IOException e2) {
            System.err.printf("Failed to load configuration file: %s%n", e2.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new String[0];
    }

    @Override
    public boolean supported() {
        File configurationFile = ConfigurationFileDiscoveryDirectoryProvider.getConfigurationFile();
        return configurationFile.exists() && configurationFile.isFile() && configurationFile.canRead();
    }

    private static final File getConfigurationFile() {
        return new File(CONFIG_DIR, CONFIG_FILE_NAME);
    }
}

