/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory.discovery;

import com.sun.jna.NativeLibrary;
import com.sun.jna.StringArray;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.RuntimeUtil;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.factory.discovery.strategy.LinuxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.OsxNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.factory.discovery.strategy.WindowsNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.support.version.LibVlcVersion;

public class NativeDiscovery {
    protected static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private static boolean alreadyFound;
    private NativeDiscoveryStrategy successfulStrategy;
    private String discoveredPath;
    private static final NativeDiscoveryStrategy[] DEFAULT_STRATEGIES;
    private final NativeDiscoveryStrategy[] discoveryStrategies;
    private static Field searchPaths;
    private static Field libraries;
    public static final Logger LOGGER;
    public static final Marker IT;

    public NativeDiscovery(NativeDiscoveryStrategy ... discoveryStrategies) {
        this.discoveryStrategies = discoveryStrategies.length > 0 ? discoveryStrategies : DEFAULT_STRATEGIES;
    }

    public final boolean discover() {
        if (alreadyFound) {
            return true;
        }
        for (NativeDiscoveryStrategy discoveryStrategy : this.discoveryStrategies) {
            String path;
            if (!discoveryStrategy.supported() || (path = discoveryStrategy.discover()) == null) continue;
            if (discoveryStrategy.onFound(path)) {
                NativeLibrary.addSearchPath(RuntimeUtil.getLibVlcLibraryName(), path);
            }
            this.tryPluginPath(path, discoveryStrategy);
            if (this.tryLoadingLibrary()) {
                this.successfulStrategy = discoveryStrategy;
                this.discoveredPath = path;
                this.onFound(path, discoveryStrategy);
                alreadyFound = true;
                return true;
            }
            LOGGER.error(IT, "Failed loading VLC in '{}' using '{}' cleaning JNA", (Object)path, (Object)discoveryStrategy.getClass().getSimpleName());
            if (this.attemptFix()) continue;
            this.onFailed(path, discoveryStrategy);
            return false;
        }
        this.onNotFound();
        return false;
    }

    public boolean attemptFix() {
        try {
            if (searchPaths == null) {
                searchPaths = NativeLibrary.class.getDeclaredField("searchPaths");
                searchPaths.setAccessible(true);
                libraries = NativeLibrary.class.getDeclaredField("libraries");
                libraries.setAccessible(true);
            }
            Map libs = (Map)libraries.get(null);
            Map paths = (Map)searchPaths.get(null);
            libs.remove(RuntimeUtil.getLibVlcCoreLibraryName());
            paths.remove(RuntimeUtil.getLibVlcCoreLibraryName());
            libs.remove(RuntimeUtil.getLibVlcLibraryName());
            paths.remove(RuntimeUtil.getLibVlcLibraryName());
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e2) {
            LOGGER.error(IT, "attemptFix failed", (Throwable)e2);
            return false;
        }
    }

    public final NativeDiscoveryStrategy successfulStrategy() {
        return this.successfulStrategy;
    }

    public final String discoveredPath() {
        return this.discoveredPath;
    }

    private void tryPluginPath(String path, NativeDiscoveryStrategy discoveryStrategy) {
        String env = System.getenv(PLUGIN_ENV_NAME);
        if (env == null || env.isEmpty()) {
            discoveryStrategy.onSetPluginPath(path);
        }
    }

    private boolean tryLoadingLibrary() {
        try {
            libvlc_instance_t instance = LibVlc.libvlc_new(0, new StringArray(new String[0]));
            if (instance != null) {
                LibVlc.libvlc_release(instance);
                LibVlcVersion version = new LibVlcVersion();
                if (version.isSupported()) {
                    return true;
                }
            }
        }
        catch (UnsatisfiedLinkError e2) {
            LOGGER.fatal(IT, "Attempt to load a VLC instance was failed", (Throwable)e2);
        }
        return false;
    }

    protected void onFound(String path, NativeDiscoveryStrategy strategy) {
    }

    protected void onFailed(String path, NativeDiscoveryStrategy strategy) {
    }

    protected void onNotFound() {
    }

    static {
        DEFAULT_STRATEGIES = new NativeDiscoveryStrategy[]{new LinuxNativeDiscoveryStrategy(), new OsxNativeDiscoveryStrategy(), new WindowsNativeDiscoveryStrategy()};
        LOGGER = LogManager.getLogger((String)"VLCJ");
        IT = MarkerManager.getMarker((String)"NativeDiscovery");
    }
}

