/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_discoverer_description_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_media_discoverer_t;
import uk.co.caprica.vlcj.binding.support.size_t;
import uk.co.caprica.vlcj.factory.BaseApi;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.media.discoverer.MediaDiscoverer;
import uk.co.caprica.vlcj.media.discoverer.MediaDiscovererCategory;
import uk.co.caprica.vlcj.media.discoverer.MediaDiscovererDescription;
import uk.co.caprica.vlcj.media.discoverer.MediaDiscovererFactory;

public final class MediaDiscovererApi
extends BaseApi {
    MediaDiscovererApi(MediaPlayerFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaDiscovererDescription> discoverers(MediaDiscovererCategory category) {
        PointerByReference ref = new PointerByReference();
        size_t size = LibVlc.libvlc_media_discoverer_list_get(this.libvlcInstance, category.intValue(), ref);
        try {
            int count = size.intValue();
            ArrayList<MediaDiscovererDescription> result = new ArrayList<MediaDiscovererDescription>(count);
            if (count > 0) {
                Pointer[] pointers;
                for (Pointer pointer : pointers = ref.getValue().getPointerArray(0L, count)) {
                    libvlc_media_discoverer_description_t description = (libvlc_media_discoverer_description_t)Structure.newInstance(libvlc_media_discoverer_description_t.class, pointer);
                    description.read();
                    result.add(new MediaDiscovererDescription(description.psz_name, description.psz_longname, MediaDiscovererCategory.mediaDiscovererCategory(description.i_cat)));
                }
            }
            ArrayList<MediaDiscovererDescription> arrayList = result;
            return arrayList;
        }
        finally {
            LibVlc.libvlc_media_discoverer_list_release(ref.getValue(), size);
        }
    }

    public MediaDiscoverer discoverer(String name) {
        libvlc_media_discoverer_t discoverer = LibVlc.libvlc_media_discoverer_new(this.libvlcInstance, name);
        if (discoverer != null) {
            return MediaDiscovererFactory.newMediaDiscoverer(this.libvlcInstance, discoverer);
        }
        return null;
    }
}

