/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.simple;

import org.tukaani.xz.simple.SimpleFilter;

public final class X86
implements SimpleFilter {
    private static final boolean[] MASK_TO_ALLOWED_STATUS = new boolean[]{true, true, true, false, true, false, false, false};
    private static final int[] MASK_TO_BIT_NUMBER = new int[]{0, 1, 2, 2, 3, 3, 3, 3};
    private final boolean isEncoder;
    private int pos;
    private int prevMask = 0;

    private static boolean test86MSByte(byte by2) {
        int n2 = by2 & 0xFF;
        return n2 == 0 || n2 == 255;
    }

    public X86(boolean bl2, int n2) {
        this.isEncoder = bl2;
        this.pos = n2 + 5;
    }

    @Override
    public int code(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n2 - 1;
        int n6 = n2 + n3 - 5;
        for (n4 = n2; n4 <= n6; ++n4) {
            if ((byArray[n4] & 0xFE) != 232) continue;
            if (((n5 = n4 - n5) & 0xFFFFFFFC) != 0) {
                this.prevMask = 0;
            } else {
                this.prevMask = this.prevMask << n5 - 1 & 7;
                if (this.prevMask != 0 && (!MASK_TO_ALLOWED_STATUS[this.prevMask] || X86.test86MSByte(byArray[n4 + 4 - MASK_TO_BIT_NUMBER[this.prevMask]]))) {
                    n5 = n4;
                    this.prevMask = this.prevMask << 1 | 1;
                    continue;
                }
            }
            n5 = n4;
            if (X86.test86MSByte(byArray[n4 + 4])) {
                int n7;
                int n8 = byArray[n4 + 1] & 0xFF | (byArray[n4 + 2] & 0xFF) << 8 | (byArray[n4 + 3] & 0xFF) << 16 | (byArray[n4 + 4] & 0xFF) << 24;
                while (true) {
                    int n9;
                    n7 = this.isEncoder ? n8 + (this.pos + n4 - n2) : n8 - (this.pos + n4 - n2);
                    if (this.prevMask == 0 || !X86.test86MSByte((byte)(n7 >>> 24 - (n9 = MASK_TO_BIT_NUMBER[this.prevMask] * 8)))) break;
                    n8 = n7 ^ (1 << 32 - n9) - 1;
                }
                byArray[n4 + 1] = (byte)n7;
                byArray[n4 + 2] = (byte)(n7 >>> 8);
                byArray[n4 + 3] = (byte)(n7 >>> 16);
                byArray[n4 + 4] = (byte)(~((n7 >>> 24 & 1) - 1));
                n4 += 4;
                continue;
            }
            this.prevMask = this.prevMask << 1 | 1;
        }
        this.prevMask = ((n5 = n4 - n5) & 0xFFFFFFFC) != 0 ? 0 : this.prevMask << n5 - 1;
        this.pos += (n4 -= n2);
        return n4;
    }
}

