/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lzma;

import java.io.IOException;
import org.tukaani.xz.lz.LZDecoder;
import org.tukaani.xz.lzma.LZMACoder;
import org.tukaani.xz.rangecoder.RangeDecoder;

public final class LZMADecoder
extends LZMACoder {
    private final LZDecoder lz;
    private final RangeDecoder rc;
    private final LiteralDecoder literalDecoder;
    private final LengthDecoder matchLenDecoder = new LengthDecoder();
    private final LengthDecoder repLenDecoder = new LengthDecoder();

    public LZMADecoder(LZDecoder lZDecoder, RangeDecoder rangeDecoder, int n2, int n3, int n4) {
        super(n4);
        this.lz = lZDecoder;
        this.rc = rangeDecoder;
        this.literalDecoder = new LiteralDecoder(n2, n3);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.literalDecoder.reset();
        this.matchLenDecoder.reset();
        this.repLenDecoder.reset();
    }

    public boolean endMarkerDetected() {
        return this.reps[0] == -1;
    }

    public void decode() throws IOException {
        this.lz.repeatPending();
        while (this.lz.hasSpace()) {
            int n2 = this.lz.getPos() & this.posMask;
            if (this.rc.decodeBit(this.isMatch[this.state.get()], n2) == 0) {
                this.literalDecoder.decode();
                continue;
            }
            int n3 = this.rc.decodeBit(this.isRep, this.state.get()) == 0 ? this.decodeMatch(n2) : this.decodeRepMatch(n2);
            this.lz.repeat(this.reps[0], n3);
        }
        this.rc.normalize();
    }

    private int decodeMatch(int n2) throws IOException {
        this.state.updateMatch();
        this.reps[3] = this.reps[2];
        this.reps[2] = this.reps[1];
        this.reps[1] = this.reps[0];
        int n3 = this.matchLenDecoder.decode(n2);
        int n4 = this.rc.decodeBitTree(this.distSlots[LZMADecoder.getDistState(n3)]);
        if (n4 < 4) {
            this.reps[0] = n4;
        } else {
            int n5 = (n4 >> 1) - 1;
            this.reps[0] = (2 | n4 & 1) << n5;
            if (n4 < 14) {
                this.reps[0] = this.reps[0] | this.rc.decodeReverseBitTree(this.distSpecial[n4 - 4]);
            } else {
                this.reps[0] = this.reps[0] | this.rc.decodeDirectBits(n5 - 4) << 4;
                this.reps[0] = this.reps[0] | this.rc.decodeReverseBitTree(this.distAlign);
            }
        }
        return n3;
    }

    private int decodeRepMatch(int n2) throws IOException {
        if (this.rc.decodeBit(this.isRep0, this.state.get()) == 0) {
            if (this.rc.decodeBit(this.isRep0Long[this.state.get()], n2) == 0) {
                this.state.updateShortRep();
                return 1;
            }
        } else {
            int n3;
            if (this.rc.decodeBit(this.isRep1, this.state.get()) == 0) {
                n3 = this.reps[1];
            } else {
                if (this.rc.decodeBit(this.isRep2, this.state.get()) == 0) {
                    n3 = this.reps[2];
                } else {
                    n3 = this.reps[3];
                    this.reps[3] = this.reps[2];
                }
                this.reps[2] = this.reps[1];
            }
            this.reps[1] = this.reps[0];
            this.reps[0] = n3;
        }
        this.state.updateLongRep();
        return this.repLenDecoder.decode(n2);
    }

    private class LengthDecoder
    extends LZMACoder.LengthCoder {
        private LengthDecoder() {
            super(LZMADecoder.this);
        }

        int decode(int n2) throws IOException {
            if (LZMADecoder.this.rc.decodeBit(this.choice, 0) == 0) {
                return LZMADecoder.this.rc.decodeBitTree(this.low[n2]) + 2;
            }
            if (LZMADecoder.this.rc.decodeBit(this.choice, 1) == 0) {
                return LZMADecoder.this.rc.decodeBitTree(this.mid[n2]) + 2 + 8;
            }
            return LZMADecoder.this.rc.decodeBitTree(this.high) + 2 + 8 + 8;
        }
    }

    private class LiteralDecoder
    extends LZMACoder.LiteralCoder {
        private final LiteralSubdecoder[] subdecoders;

        LiteralDecoder(int n2, int n3) {
            super(LZMADecoder.this, n2, n3);
            this.subdecoders = new LiteralSubdecoder[1 << n2 + n3];
            for (int i2 = 0; i2 < this.subdecoders.length; ++i2) {
                this.subdecoders[i2] = new LiteralSubdecoder();
            }
        }

        void reset() {
            for (int i2 = 0; i2 < this.subdecoders.length; ++i2) {
                this.subdecoders[i2].reset();
            }
        }

        void decode() throws IOException {
            int n2 = this.getSubcoderIndex(LZMADecoder.this.lz.getByte(0), LZMADecoder.this.lz.getPos());
            this.subdecoders[n2].decode();
        }

        private class LiteralSubdecoder
        extends LZMACoder.LiteralCoder.LiteralSubcoder {
            private LiteralSubdecoder() {
                super(LiteralDecoder.this);
            }

            void decode() throws IOException {
                int n2 = 1;
                if (LZMADecoder.this.state.isLiteral()) {
                    while ((n2 = n2 << 1 | LZMADecoder.this.rc.decodeBit(this.probs, n2)) < 256) {
                    }
                } else {
                    int n3 = LZMADecoder.this.lz.getByte(LZMADecoder.this.reps[0]);
                    int n4 = 256;
                    do {
                        int n5 = (n3 <<= 1) & n4;
                        int n6 = LZMADecoder.this.rc.decodeBit(this.probs, n4 + n5 + n2);
                        n2 = n2 << 1 | n6;
                        n4 &= 0 - n6 ^ ~n5;
                    } while (n2 < 256);
                }
                LZMADecoder.this.lz.putByte((byte)n2);
                LZMADecoder.this.state.updateLiteral();
            }
        }
    }
}

