/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lz;

import java.io.IOException;
import java.io.OutputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.lz.BT4;
import org.tukaani.xz.lz.HC4;
import org.tukaani.xz.lz.Matches;

public abstract class LZEncoder {
    public static final int MF_HC4 = 4;
    public static final int MF_BT4 = 20;
    private final int keepSizeBefore;
    private final int keepSizeAfter;
    final int matchLenMax;
    final int niceLen;
    final byte[] buf;
    final int bufSize;
    int readPos = -1;
    private int readLimit = -1;
    private boolean finishing = false;
    private int writePos = 0;
    private int pendingSize = 0;

    static void normalize(int[] nArray, int n2, int n3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] <= n3) {
                nArray[i2] = 0;
                continue;
            }
            int n4 = i2;
            nArray[n4] = nArray[n4] - n3;
        }
    }

    private static int getBufSize(int n2, int n3, int n4, int n5) {
        int n6 = n3 + n2;
        int n7 = n4 + n5;
        int n8 = Math.min(n2 / 2 + 262144, 0x20000000);
        return n6 + n7 + n8;
    }

    public static int getMemoryUsage(int n2, int n3, int n4, int n5, int n6) {
        int n7 = LZEncoder.getBufSize(n2, n3, n4, n5) / 1024 + 10;
        switch (n6) {
            case 4: {
                n7 += HC4.getMemoryUsage(n2);
                break;
            }
            case 20: {
                n7 += BT4.getMemoryUsage(n2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n7;
    }

    public static LZEncoder getInstance(int n2, int n3, int n4, int n5, int n6, int n7, int n8, ArrayCache arrayCache) {
        switch (n7) {
            case 4: {
                return new HC4(n2, n3, n4, n5, n6, n8, arrayCache);
            }
            case 20: {
                return new BT4(n2, n3, n4, n5, n6, n8, arrayCache);
            }
        }
        throw new IllegalArgumentException();
    }

    LZEncoder(int n2, int n3, int n4, int n5, int n6, ArrayCache arrayCache) {
        this.bufSize = LZEncoder.getBufSize(n2, n3, n4, n6);
        this.buf = arrayCache.getByteArray(this.bufSize, false);
        this.keepSizeBefore = n3 + n2;
        this.keepSizeAfter = n4 + n6;
        this.matchLenMax = n6;
        this.niceLen = n5;
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    public void setPresetDict(int n2, byte[] byArray) {
        assert (!this.isStarted());
        assert (this.writePos == 0);
        if (byArray != null) {
            int n3 = Math.min(byArray.length, n2);
            int n4 = byArray.length - n3;
            System.arraycopy(byArray, n4, this.buf, 0, n3);
            this.writePos += n3;
            this.skip(n3);
        }
    }

    private void moveWindow() {
        int n2 = this.readPos + 1 - this.keepSizeBefore & 0xFFFFFFF0;
        int n3 = this.writePos - n2;
        System.arraycopy(this.buf, n2, this.buf, 0, n3);
        this.readPos -= n2;
        this.readLimit -= n2;
        this.writePos -= n2;
    }

    public int fillWindow(byte[] byArray, int n2, int n3) {
        assert (!this.finishing);
        if (this.readPos >= this.bufSize - this.keepSizeAfter) {
            this.moveWindow();
        }
        if (n3 > this.bufSize - this.writePos) {
            n3 = this.bufSize - this.writePos;
        }
        System.arraycopy(byArray, n2, this.buf, this.writePos, n3);
        this.writePos += n3;
        if (this.writePos >= this.keepSizeAfter) {
            this.readLimit = this.writePos - this.keepSizeAfter;
        }
        this.processPendingBytes();
        return n3;
    }

    private void processPendingBytes() {
        if (this.pendingSize > 0 && this.readPos < this.readLimit) {
            this.readPos -= this.pendingSize;
            int n2 = this.pendingSize;
            this.pendingSize = 0;
            this.skip(n2);
            assert (this.pendingSize < n2);
        }
    }

    public boolean isStarted() {
        return this.readPos != -1;
    }

    public void setFlushing() {
        this.readLimit = this.writePos - 1;
        this.processPendingBytes();
    }

    public void setFinishing() {
        this.readLimit = this.writePos - 1;
        this.finishing = true;
        this.processPendingBytes();
    }

    public boolean hasEnoughData(int n2) {
        return this.readPos - n2 < this.readLimit;
    }

    public void copyUncompressed(OutputStream outputStream, int n2, int n3) throws IOException {
        outputStream.write(this.buf, this.readPos + 1 - n2, n3);
    }

    public int getAvail() {
        assert (this.isStarted());
        return this.writePos - this.readPos;
    }

    public int getPos() {
        return this.readPos;
    }

    public int getByte(int n2) {
        return this.buf[this.readPos - n2] & 0xFF;
    }

    public int getByte(int n2, int n3) {
        return this.buf[this.readPos + n2 - n3] & 0xFF;
    }

    public int getMatchLen(int n2, int n3) {
        int n4;
        int n5 = this.readPos - n2 - 1;
        for (n4 = 0; n4 < n3 && this.buf[this.readPos + n4] == this.buf[n5 + n4]; ++n4) {
        }
        return n4;
    }

    public int getMatchLen(int n2, int n3, int n4) {
        int n5;
        int n6 = this.readPos + n2;
        int n7 = n6 - n3 - 1;
        for (n5 = 0; n5 < n4 && this.buf[n6 + n5] == this.buf[n7 + n5]; ++n5) {
        }
        return n5;
    }

    public boolean verifyMatches(Matches matches) {
        int n2 = Math.min(this.getAvail(), this.matchLenMax);
        for (int i2 = 0; i2 < matches.count; ++i2) {
            if (this.getMatchLen(matches.dist[i2], n2) == matches.len[i2]) continue;
            return false;
        }
        return true;
    }

    int movePos(int n2, int n3) {
        assert (n2 >= n3);
        ++this.readPos;
        int n4 = this.writePos - this.readPos;
        if (!(n4 >= n2 || n4 >= n3 && this.finishing)) {
            ++this.pendingSize;
            n4 = 0;
        }
        return n4;
    }

    public abstract Matches getMatches();

    public abstract void skip(int var1);
}

