/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lz;

import java.io.DataInputStream;
import java.io.IOException;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.CorruptedInputException;

public final class LZDecoder {
    private final byte[] buf;
    private final int bufSize;
    private int start = 0;
    private int pos = 0;
    private int full = 0;
    private int limit = 0;
    private int pendingLen = 0;
    private int pendingDist = 0;

    public LZDecoder(int n2, byte[] byArray, ArrayCache arrayCache) {
        this.bufSize = n2;
        this.buf = arrayCache.getByteArray(this.bufSize, false);
        if (byArray != null) {
            this.full = this.pos = Math.min(byArray.length, n2);
            this.start = this.pos;
            System.arraycopy(byArray, byArray.length - this.pos, this.buf, 0, this.pos);
        }
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    public void reset() {
        this.start = 0;
        this.pos = 0;
        this.full = 0;
        this.limit = 0;
        this.buf[this.bufSize - 1] = 0;
    }

    public void setLimit(int n2) {
        this.limit = this.bufSize - this.pos <= n2 ? this.bufSize : this.pos + n2;
    }

    public boolean hasSpace() {
        return this.pos < this.limit;
    }

    public boolean hasPending() {
        return this.pendingLen > 0;
    }

    public int getPos() {
        return this.pos;
    }

    public int getByte(int n2) {
        int n3 = this.pos - n2 - 1;
        if (n2 >= this.pos) {
            n3 += this.bufSize;
        }
        return this.buf[n3] & 0xFF;
    }

    public void putByte(byte by2) {
        this.buf[this.pos++] = by2;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeat(int n2, int n3) throws IOException {
        int n4;
        if (n2 < 0 || n2 >= this.full) {
            throw new CorruptedInputException();
        }
        int n5 = Math.min(this.limit - this.pos, n3);
        this.pendingLen = n3 - n5;
        this.pendingDist = n2;
        int n6 = this.pos - n2 - 1;
        if (n6 < 0) {
            assert (this.full == this.bufSize);
            n4 = Math.min(this.bufSize - (n6 += this.bufSize), n5);
            assert (n4 <= n2 + 1);
            System.arraycopy(this.buf, n6, this.buf, this.pos, n4);
            this.pos += n4;
            n6 = 0;
            if ((n5 -= n4) == 0) {
                return;
            }
        }
        assert (n6 < this.pos);
        assert (n5 > 0);
        do {
            n4 = Math.min(n5, this.pos - n6);
            System.arraycopy(this.buf, n6, this.buf, this.pos, n4);
            this.pos += n4;
        } while ((n5 -= n4) > 0);
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeatPending() throws IOException {
        if (this.pendingLen > 0) {
            this.repeat(this.pendingDist, this.pendingLen);
        }
    }

    public void copyUncompressed(DataInputStream dataInputStream, int n2) throws IOException {
        int n3 = Math.min(this.bufSize - this.pos, n2);
        dataInputStream.readFully(this.buf, this.pos, n3);
        this.pos += n3;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public int flush(byte[] byArray, int n2) {
        int n3 = this.pos - this.start;
        if (this.pos == this.bufSize) {
            this.pos = 0;
        }
        System.arraycopy(this.buf, this.start, byArray, n2, n3);
        this.start = this.pos;
        return n3;
    }
}

