/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lz;

import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.lz.Hash234;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lz.Matches;

final class HC4
extends LZEncoder {
    private final Hash234 hash;
    private final int[] chain;
    private final Matches matches;
    private final int depthLimit;
    private final int cyclicSize;
    private int cyclicPos = -1;
    private int lzPos;

    static int getMemoryUsage(int n2) {
        return Hash234.getMemoryUsage(n2) + n2 / 256 + 10;
    }

    HC4(int n2, int n3, int n4, int n5, int n6, int n7, ArrayCache arrayCache) {
        super(n2, n3, n4, n5, n6, arrayCache);
        this.hash = new Hash234(n2, arrayCache);
        this.cyclicSize = n2 + 1;
        this.chain = arrayCache.getIntArray(this.cyclicSize, false);
        this.lzPos = this.cyclicSize;
        this.matches = new Matches(n5 - 1);
        this.depthLimit = n7 > 0 ? n7 : 4 + n5 / 4;
    }

    @Override
    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.chain);
        this.hash.putArraysToCache(arrayCache);
        super.putArraysToCache(arrayCache);
    }

    private int movePos() {
        int n2 = this.movePos(4, 4);
        if (n2 != 0) {
            if (++this.lzPos == Integer.MAX_VALUE) {
                int n3 = Integer.MAX_VALUE - this.cyclicSize;
                this.hash.normalize(n3);
                HC4.normalize(this.chain, this.cyclicSize, n3);
                this.lzPos -= n3;
            }
            if (++this.cyclicPos == this.cyclicSize) {
                this.cyclicPos = 0;
            }
        }
        return n2;
    }

    @Override
    public Matches getMatches() {
        this.matches.count = 0;
        int n2 = this.matchLenMax;
        int n3 = this.niceLen;
        int n4 = this.movePos();
        if (n4 < n2) {
            if (n4 == 0) {
                return this.matches;
            }
            n2 = n4;
            if (n3 > n4) {
                n3 = n4;
            }
        }
        this.hash.calcHashes(this.buf, this.readPos);
        int n5 = this.lzPos - this.hash.getHash2Pos();
        int n6 = this.lzPos - this.hash.getHash3Pos();
        int n7 = this.hash.getHash4Pos();
        this.hash.updateTables(this.lzPos);
        this.chain[this.cyclicPos] = n7;
        int n8 = 0;
        if (n5 < this.cyclicSize && this.buf[this.readPos - n5] == this.buf[this.readPos]) {
            n8 = 2;
            this.matches.len[0] = 2;
            this.matches.dist[0] = n5 - 1;
            this.matches.count = 1;
        }
        if (n5 != n6 && n6 < this.cyclicSize && this.buf[this.readPos - n6] == this.buf[this.readPos]) {
            n8 = 3;
            this.matches.dist[this.matches.count++] = n6 - 1;
            n5 = n6;
        }
        if (this.matches.count > 0) {
            while (n8 < n2 && this.buf[this.readPos + n8 - n5] == this.buf[this.readPos + n8]) {
                ++n8;
            }
            this.matches.len[this.matches.count - 1] = n8;
            if (n8 >= n3) {
                return this.matches;
            }
        }
        if (n8 < 3) {
            n8 = 3;
        }
        int n9 = this.depthLimit;
        while (true) {
            int n10 = this.lzPos - n7;
            if (n9-- == 0 || n10 >= this.cyclicSize) {
                return this.matches;
            }
            n7 = this.chain[this.cyclicPos - n10 + (n10 > this.cyclicPos ? this.cyclicSize : 0)];
            if (this.buf[this.readPos + n8 - n10] != this.buf[this.readPos + n8] || this.buf[this.readPos - n10] != this.buf[this.readPos]) continue;
            int n11 = 0;
            while (++n11 < n2 && this.buf[this.readPos + n11 - n10] == this.buf[this.readPos + n11]) {
            }
            if (n11 <= n8) continue;
            n8 = n11;
            this.matches.len[this.matches.count] = n11;
            this.matches.dist[this.matches.count] = n10 - 1;
            ++this.matches.count;
            if (n11 >= n3) break;
        }
        return this.matches;
    }

    @Override
    public void skip(int n2) {
        assert (n2 >= 0);
        while (n2-- > 0) {
            if (this.movePos() == 0) continue;
            this.hash.calcHashes(this.buf, this.readPos);
            this.chain[this.cyclicPos] = this.hash.getHash4Pos();
            this.hash.updateTables(this.lzPos);
        }
    }
}

