/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lz;

import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.lz.Hash234;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lz.Matches;

final class BT4
extends LZEncoder {
    private final Hash234 hash;
    private final int[] tree;
    private final Matches matches;
    private final int depthLimit;
    private final int cyclicSize;
    private int cyclicPos = -1;
    private int lzPos;

    static int getMemoryUsage(int n2) {
        return Hash234.getMemoryUsage(n2) + n2 / 128 + 10;
    }

    BT4(int n2, int n3, int n4, int n5, int n6, int n7, ArrayCache arrayCache) {
        super(n2, n3, n4, n5, n6, arrayCache);
        this.lzPos = this.cyclicSize = n2 + 1;
        this.hash = new Hash234(n2, arrayCache);
        this.tree = arrayCache.getIntArray(this.cyclicSize * 2, false);
        this.matches = new Matches(n5 - 1);
        this.depthLimit = n7 > 0 ? n7 : 16 + n5 / 2;
    }

    @Override
    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.tree);
        this.hash.putArraysToCache(arrayCache);
        super.putArraysToCache(arrayCache);
    }

    private int movePos() {
        int n2 = this.movePos(this.niceLen, 4);
        if (n2 != 0) {
            if (++this.lzPos == Integer.MAX_VALUE) {
                int n3 = Integer.MAX_VALUE - this.cyclicSize;
                this.hash.normalize(n3);
                BT4.normalize(this.tree, this.cyclicSize * 2, n3);
                this.lzPos -= n3;
            }
            if (++this.cyclicPos == this.cyclicSize) {
                this.cyclicPos = 0;
            }
        }
        return n2;
    }

    @Override
    public Matches getMatches() {
        this.matches.count = 0;
        int n2 = this.matchLenMax;
        int n3 = this.niceLen;
        int n4 = this.movePos();
        if (n4 < n2) {
            if (n4 == 0) {
                return this.matches;
            }
            n2 = n4;
            if (n3 > n4) {
                n3 = n4;
            }
        }
        this.hash.calcHashes(this.buf, this.readPos);
        int n5 = this.lzPos - this.hash.getHash2Pos();
        int n6 = this.lzPos - this.hash.getHash3Pos();
        int n7 = this.hash.getHash4Pos();
        this.hash.updateTables(this.lzPos);
        int n8 = 0;
        if (n5 < this.cyclicSize && this.buf[this.readPos - n5] == this.buf[this.readPos]) {
            n8 = 2;
            this.matches.len[0] = 2;
            this.matches.dist[0] = n5 - 1;
            this.matches.count = 1;
        }
        if (n5 != n6 && n6 < this.cyclicSize && this.buf[this.readPos - n6] == this.buf[this.readPos]) {
            n8 = 3;
            this.matches.dist[this.matches.count++] = n6 - 1;
            n5 = n6;
        }
        if (this.matches.count > 0) {
            while (n8 < n2 && this.buf[this.readPos + n8 - n5] == this.buf[this.readPos + n8]) {
                ++n8;
            }
            this.matches.len[this.matches.count - 1] = n8;
            if (n8 >= n3) {
                this.skip(n3, n7);
                return this.matches;
            }
        }
        if (n8 < 3) {
            n8 = 3;
        }
        int n9 = this.depthLimit;
        int n10 = (this.cyclicPos << 1) + 1;
        int n11 = this.cyclicPos << 1;
        int n12 = 0;
        int n13 = 0;
        while (true) {
            int n14 = this.lzPos - n7;
            if (n9-- == 0 || n14 >= this.cyclicSize) {
                this.tree[n10] = 0;
                this.tree[n11] = 0;
                return this.matches;
            }
            int n15 = this.cyclicPos - n14 + (n14 > this.cyclicPos ? this.cyclicSize : 0) << 1;
            int n16 = Math.min(n12, n13);
            if (this.buf[this.readPos + n16 - n14] == this.buf[this.readPos + n16]) {
                while (++n16 < n2 && this.buf[this.readPos + n16 - n14] == this.buf[this.readPos + n16]) {
                }
                if (n16 > n8) {
                    n8 = n16;
                    this.matches.len[this.matches.count] = n16;
                    this.matches.dist[this.matches.count] = n14 - 1;
                    ++this.matches.count;
                    if (n16 >= n3) {
                        this.tree[n11] = this.tree[n15];
                        this.tree[n10] = this.tree[n15 + 1];
                        return this.matches;
                    }
                }
            }
            if ((this.buf[this.readPos + n16 - n14] & 0xFF) < (this.buf[this.readPos + n16] & 0xFF)) {
                this.tree[n11] = n7;
                n11 = n15 + 1;
                n7 = this.tree[n11];
                n13 = n16;
                continue;
            }
            this.tree[n10] = n7;
            n10 = n15;
            n7 = this.tree[n10];
            n12 = n16;
        }
    }

    private void skip(int n2, int n3) {
        int n4 = this.depthLimit;
        int n5 = (this.cyclicPos << 1) + 1;
        int n6 = this.cyclicPos << 1;
        int n7 = 0;
        int n8 = 0;
        while (true) {
            int n9 = this.lzPos - n3;
            if (n4-- == 0 || n9 >= this.cyclicSize) {
                this.tree[n5] = 0;
                this.tree[n6] = 0;
                return;
            }
            int n10 = this.cyclicPos - n9 + (n9 > this.cyclicPos ? this.cyclicSize : 0) << 1;
            int n11 = Math.min(n7, n8);
            if (this.buf[this.readPos + n11 - n9] == this.buf[this.readPos + n11]) {
                do {
                    if (++n11 != n2) continue;
                    this.tree[n6] = this.tree[n10];
                    this.tree[n5] = this.tree[n10 + 1];
                    return;
                } while (this.buf[this.readPos + n11 - n9] == this.buf[this.readPos + n11]);
            }
            if ((this.buf[this.readPos + n11 - n9] & 0xFF) < (this.buf[this.readPos + n11] & 0xFF)) {
                this.tree[n6] = n3;
                n6 = n10 + 1;
                n3 = this.tree[n6];
                n8 = n11;
                continue;
            }
            this.tree[n5] = n3;
            n5 = n10;
            n3 = this.tree[n5];
            n7 = n11;
        }
    }

    @Override
    public void skip(int n2) {
        while (n2-- > 0) {
            int n3 = this.niceLen;
            int n4 = this.movePos();
            if (n4 < n3) {
                if (n4 == 0) continue;
                n3 = n4;
            }
            this.hash.calcHashes(this.buf, this.readPos);
            int n5 = this.hash.getHash4Pos();
            this.hash.updateTables(this.lzPos);
            this.skip(n3, n5);
        }
    }
}

