/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.index;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.SeekableInputStream;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.common.DecoderUtil;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.index.BlockInfo;
import org.tukaani.xz.index.IndexBase;

public class IndexDecoder
extends IndexBase {
    private final StreamFlags streamFlags;
    private final long streamPadding;
    private final int memoryUsage;
    private final long[] unpadded;
    private final long[] uncompressed;
    private long largestBlockSize = 0L;
    private int recordOffset = 0;
    private long compressedOffset = 0L;
    private long uncompressedOffset = 0L;

    public IndexDecoder(SeekableInputStream seekableInputStream, StreamFlags streamFlags, long l2, int n2) throws IOException {
        super(new CorruptedInputException("XZ Index is corrupt"));
        int n3;
        this.streamFlags = streamFlags;
        this.streamPadding = l2;
        long l3 = seekableInputStream.position() + streamFlags.backwardSize - 4L;
        CRC32 cRC32 = new CRC32();
        CheckedInputStream checkedInputStream = new CheckedInputStream(seekableInputStream, cRC32);
        if (checkedInputStream.read() != 0) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        try {
            long l4 = DecoderUtil.decodeVLI(checkedInputStream);
            if (l4 >= streamFlags.backwardSize / 2L) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            if (l4 > Integer.MAX_VALUE) {
                throw new UnsupportedOptionsException("XZ Index has over 2147483647 Records");
            }
            this.memoryUsage = 1 + (int)((16L * l4 + 1023L) / 1024L);
            if (n2 >= 0 && this.memoryUsage > n2) {
                throw new MemoryLimitException(this.memoryUsage, n2);
            }
            this.unpadded = new long[(int)l4];
            this.uncompressed = new long[(int)l4];
            int n4 = 0;
            for (n3 = (int)l4; n3 > 0; --n3) {
                long l5 = DecoderUtil.decodeVLI(checkedInputStream);
                long l6 = DecoderUtil.decodeVLI(checkedInputStream);
                if (seekableInputStream.position() > l3) {
                    throw new CorruptedInputException("XZ Index is corrupt");
                }
                this.unpadded[n4] = this.blocksSum + l5;
                this.uncompressed[n4] = this.uncompressedSum + l6;
                super.add(l5, l6);
                assert ((long)(++n4) == this.recordCount);
                if (this.largestBlockSize >= l6) continue;
                this.largestBlockSize = l6;
            }
        }
        catch (EOFException eOFException) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        int n5 = this.getIndexPaddingSize();
        if (seekableInputStream.position() + (long)n5 != l3) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        while (n5-- > 0) {
            if (checkedInputStream.read() == 0) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        long l7 = cRC32.getValue();
        for (n3 = 0; n3 < 4; ++n3) {
            if ((l7 >>> n3 * 8 & 0xFFL) == (long)seekableInputStream.read()) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
    }

    public void setOffsets(IndexDecoder indexDecoder) {
        this.recordOffset = indexDecoder.recordOffset + (int)indexDecoder.recordCount;
        this.compressedOffset = indexDecoder.compressedOffset + indexDecoder.getStreamSize() + indexDecoder.streamPadding;
        assert ((this.compressedOffset & 3L) == 0L);
        this.uncompressedOffset = indexDecoder.uncompressedOffset + indexDecoder.uncompressedSum;
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public StreamFlags getStreamFlags() {
        return this.streamFlags;
    }

    public int getRecordCount() {
        return (int)this.recordCount;
    }

    public long getUncompressedSize() {
        return this.uncompressedSum;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public boolean hasUncompressedOffset(long l2) {
        return l2 >= this.uncompressedOffset && l2 < this.uncompressedOffset + this.uncompressedSum;
    }

    public boolean hasRecord(int n2) {
        return n2 >= this.recordOffset && (long)n2 < (long)this.recordOffset + this.recordCount;
    }

    public void locateBlock(BlockInfo blockInfo, long l2) {
        assert (l2 >= this.uncompressedOffset);
        assert ((l2 -= this.uncompressedOffset) < this.uncompressedSum);
        int n2 = 0;
        int n3 = this.unpadded.length - 1;
        while (n2 < n3) {
            int n4 = n2 + (n3 - n2) / 2;
            if (this.uncompressed[n4] <= l2) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
        }
        this.setBlockInfo(blockInfo, this.recordOffset + n2);
    }

    public void setBlockInfo(BlockInfo blockInfo, int n2) {
        assert (n2 >= this.recordOffset);
        assert ((long)(n2 - this.recordOffset) < this.recordCount);
        blockInfo.index = this;
        blockInfo.blockNumber = n2;
        int n3 = n2 - this.recordOffset;
        if (n3 == 0) {
            blockInfo.compressedOffset = 0L;
            blockInfo.uncompressedOffset = 0L;
        } else {
            blockInfo.compressedOffset = this.unpadded[n3 - 1] + 3L & 0xFFFFFFFFFFFFFFFCL;
            blockInfo.uncompressedOffset = this.uncompressed[n3 - 1];
        }
        blockInfo.unpaddedSize = this.unpadded[n3] - blockInfo.compressedOffset;
        blockInfo.uncompressedSize = this.uncompressed[n3] - blockInfo.uncompressedOffset;
        blockInfo.compressedOffset += this.compressedOffset + 12L;
        blockInfo.uncompressedOffset += this.uncompressedOffset;
    }
}

