/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.common;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZFormatException;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.common.Util;

public class DecoderUtil
extends Util {
    public static boolean isCRC32Valid(byte[] byArray, int n2, int n3, int n4) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, n2, n3);
        long l2 = cRC32.getValue();
        for (int i2 = 0; i2 < 4; ++i2) {
            if ((byte)(l2 >>> i2 * 8) == byArray[n4 + i2]) continue;
            return false;
        }
        return true;
    }

    public static StreamFlags decodeStreamHeader(byte[] byArray) throws IOException {
        for (int i2 = 0; i2 < XZ.HEADER_MAGIC.length; ++i2) {
            if (byArray[i2] == XZ.HEADER_MAGIC[i2]) continue;
            throw new XZFormatException();
        }
        if (!DecoderUtil.isCRC32Valid(byArray, XZ.HEADER_MAGIC.length, 2, XZ.HEADER_MAGIC.length + 2)) {
            throw new CorruptedInputException("XZ Stream Header is corrupt");
        }
        try {
            return DecoderUtil.decodeStreamFlags(byArray, XZ.HEADER_MAGIC.length);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Header");
        }
    }

    public static StreamFlags decodeStreamFooter(byte[] byArray) throws IOException {
        StreamFlags streamFlags;
        if (byArray[10] != XZ.FOOTER_MAGIC[0] || byArray[11] != XZ.FOOTER_MAGIC[1]) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        if (!DecoderUtil.isCRC32Valid(byArray, 4, 6, 0)) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        try {
            streamFlags = DecoderUtil.decodeStreamFlags(byArray, 8);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Footer");
        }
        streamFlags.backwardSize = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            streamFlags.backwardSize |= (long)((byArray[i2 + 4] & 0xFF) << i2 * 8);
        }
        streamFlags.backwardSize = (streamFlags.backwardSize + 1L) * 4L;
        return streamFlags;
    }

    private static StreamFlags decodeStreamFlags(byte[] byArray, int n2) throws UnsupportedOptionsException {
        if (byArray[n2] != 0 || (byArray[n2 + 1] & 0xFF) >= 16) {
            throw new UnsupportedOptionsException();
        }
        StreamFlags streamFlags = new StreamFlags();
        streamFlags.checkType = byArray[n2 + 1];
        return streamFlags;
    }

    public static boolean areStreamFlagsEqual(StreamFlags streamFlags, StreamFlags streamFlags2) {
        return streamFlags.checkType == streamFlags2.checkType;
    }

    public static long decodeVLI(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        long l2 = n2 & 0x7F;
        int n3 = 0;
        while ((n2 & 0x80) != 0) {
            if (++n3 >= 9) {
                throw new CorruptedInputException();
            }
            n2 = inputStream.read();
            if (n2 == -1) {
                throw new EOFException();
            }
            if (n2 == 0) {
                throw new CorruptedInputException();
            }
            l2 |= (long)(n2 & 0x7F) << n3 * 7;
        }
        return l2;
    }
}

