/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.check;

import org.tukaani.xz.check.Check;

public class CRC64
extends Check {
    private static final long[][] TABLE = new long[4][256];
    private long crc = -1L;

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n2 + n3;
        int n6 = n5 - 3;
        for (n4 = n2; n4 < n6; n4 += 4) {
            int n7 = (int)this.crc;
            this.crc = TABLE[3][n7 & 0xFF ^ byArray[n4] & 0xFF] ^ TABLE[2][n7 >>> 8 & 0xFF ^ byArray[n4 + 1] & 0xFF] ^ this.crc >>> 32 ^ TABLE[1][n7 >>> 16 & 0xFF ^ byArray[n4 + 2] & 0xFF] ^ TABLE[0][n7 >>> 24 & 0xFF ^ byArray[n4 + 3] & 0xFF];
        }
        while (n4 < n5) {
            this.crc = TABLE[0][byArray[n4++] & 0xFF ^ (int)this.crc & 0xFF] ^ this.crc >>> 8;
        }
    }

    @Override
    public byte[] finish() {
        long l2 = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(l2 >> i2 * 8);
        }
        return byArray;
    }

    static {
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int i3 = 0; i3 < 256; ++i3) {
                long l2 = i2 == 0 ? (long)i3 : TABLE[i2 - 1][i3];
                for (int i4 = 0; i4 < 8; ++i4) {
                    if ((l2 & 1L) == 1L) {
                        l2 = l2 >>> 1 ^ 0xC96C5795D7870F42L;
                        continue;
                    }
                    l2 >>>= 1;
                }
                CRC64.TABLE[i2][i3] = l2;
            }
        }
    }
}

