/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BlockInputStream;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.IndexIndicatorException;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.SeekableInputStream;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZFormatException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.DecoderUtil;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.index.BlockInfo;
import org.tukaani.xz.index.IndexDecoder;

public class SeekableXZInputStream
extends SeekableInputStream {
    private final ArrayCache arrayCache;
    private SeekableInputStream in;
    private final int memoryLimit;
    private int indexMemoryUsage = 0;
    private final ArrayList<IndexDecoder> streams = new ArrayList();
    private int checkTypes = 0;
    private long uncompressedSize = 0L;
    private long largestBlockSize = 0L;
    private int blockCount = 0;
    private final BlockInfo curBlockInfo;
    private final BlockInfo queriedBlockInfo;
    private Check check;
    private final boolean verifyCheck;
    private BlockInputStream blockDecoder = null;
    private long curPos = 0L;
    private long seekPos;
    private boolean seekNeeded = false;
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public SeekableXZInputStream(SeekableInputStream seekableInputStream) throws IOException {
        this(seekableInputStream, -1);
    }

    public SeekableXZInputStream(SeekableInputStream seekableInputStream, ArrayCache arrayCache) throws IOException {
        this(seekableInputStream, -1, arrayCache);
    }

    public SeekableXZInputStream(SeekableInputStream seekableInputStream, int n2) throws IOException {
        this(seekableInputStream, n2, true);
    }

    public SeekableXZInputStream(SeekableInputStream seekableInputStream, int n2, ArrayCache arrayCache) throws IOException {
        this(seekableInputStream, n2, true, arrayCache);
    }

    public SeekableXZInputStream(SeekableInputStream seekableInputStream, int n2, boolean bl2) throws IOException {
        this(seekableInputStream, n2, bl2, ArrayCache.getDefaultCache());
    }

    public SeekableXZInputStream(SeekableInputStream seekableInputStream, int n2, boolean bl2, ArrayCache arrayCache) throws IOException {
        Object object;
        this.arrayCache = arrayCache;
        this.verifyCheck = bl2;
        this.in = seekableInputStream;
        DataInputStream dataInputStream = new DataInputStream(seekableInputStream);
        seekableInputStream.seek(0L);
        byte[] byArray = new byte[XZ.HEADER_MAGIC.length];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, XZ.HEADER_MAGIC)) {
            throw new XZFormatException();
        }
        long l2 = seekableInputStream.length();
        if ((l2 & 3L) != 0L) {
            throw new CorruptedInputException("XZ file size is not a multiple of 4 bytes");
        }
        byte[] byArray2 = new byte[12];
        long l3 = 0L;
        while (l2 > 0L) {
            long l4;
            IndexDecoder indexDecoder;
            if (l2 < 12L) {
                throw new CorruptedInputException();
            }
            seekableInputStream.seek(l2 - 12L);
            dataInputStream.readFully(byArray2);
            if (byArray2[8] == 0 && byArray2[9] == 0 && byArray2[10] == 0 && byArray2[11] == 0) {
                l3 += 4L;
                l2 -= 4L;
                continue;
            }
            object = DecoderUtil.decodeStreamFooter(byArray2);
            if (((StreamFlags)object).backwardSize >= (l2 -= 12L)) {
                throw new CorruptedInputException("Backward Size in XZ Stream Footer is too big");
            }
            this.check = Check.getInstance(((StreamFlags)object).checkType);
            this.checkTypes |= 1 << ((StreamFlags)object).checkType;
            seekableInputStream.seek(l2 - ((StreamFlags)object).backwardSize);
            try {
                indexDecoder = new IndexDecoder(seekableInputStream, (StreamFlags)object, l3, n2);
            }
            catch (MemoryLimitException memoryLimitException) {
                assert (n2 >= 0);
                throw new MemoryLimitException(memoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, n2 + this.indexMemoryUsage);
            }
            this.indexMemoryUsage += indexDecoder.getMemoryUsage();
            if (n2 >= 0) assert ((n2 -= indexDecoder.getMemoryUsage()) >= 0);
            if (this.largestBlockSize < indexDecoder.getLargestBlockSize()) {
                this.largestBlockSize = indexDecoder.getLargestBlockSize();
            }
            if (l2 < (l4 = indexDecoder.getStreamSize() - 12L)) {
                throw new CorruptedInputException("XZ Index indicates too big compressed size for the XZ Stream");
            }
            seekableInputStream.seek(l2 -= l4);
            dataInputStream.readFully(byArray2);
            StreamFlags streamFlags = DecoderUtil.decodeStreamHeader(byArray2);
            if (!DecoderUtil.areStreamFlagsEqual(streamFlags, (StreamFlags)object)) {
                throw new CorruptedInputException("XZ Stream Footer does not match Stream Header");
            }
            this.uncompressedSize += indexDecoder.getUncompressedSize();
            if (this.uncompressedSize < 0L) {
                throw new UnsupportedOptionsException("XZ file is too big");
            }
            this.blockCount += indexDecoder.getRecordCount();
            if (this.blockCount < 0) {
                throw new UnsupportedOptionsException("XZ file has over 2147483647 Blocks");
            }
            this.streams.add(indexDecoder);
            l3 = 0L;
        }
        assert (l2 == 0L);
        this.memoryLimit = n2;
        object = this.streams.get(this.streams.size() - 1);
        for (int i2 = this.streams.size() - 2; i2 >= 0; --i2) {
            IndexDecoder indexDecoder = this.streams.get(i2);
            indexDecoder.setOffsets((IndexDecoder)object);
            object = indexDecoder;
        }
        IndexDecoder indexDecoder = this.streams.get(this.streams.size() - 1);
        this.curBlockInfo = new BlockInfo(indexDecoder);
        this.queriedBlockInfo = new BlockInfo(indexDecoder);
    }

    public int getCheckTypes() {
        return this.checkTypes;
    }

    public int getIndexMemoryUsage() {
        return this.indexMemoryUsage;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public int getStreamCount() {
        return this.streams.size();
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public long getBlockPos(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.uncompressedOffset;
    }

    public long getBlockSize(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.uncompressedSize;
    }

    public long getBlockCompPos(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.compressedOffset;
    }

    public long getBlockCompSize(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.unpaddedSize + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    public int getBlockCheckType(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.getCheckType();
    }

    public int getBlockNumber(long l2) {
        this.locateBlockByPos(this.queriedBlockInfo, l2);
        return this.queriedBlockInfo.blockNumber;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        block13: {
            if (n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            n4 = 0;
            try {
                if (this.seekNeeded) {
                    this.seek();
                }
                if (this.endReached) {
                    return -1;
                }
                while (n3 > 0) {
                    int n5;
                    if (this.blockDecoder == null) {
                        this.seek();
                        if (this.endReached) break;
                    }
                    if ((n5 = this.blockDecoder.read(byArray, n2, n3)) > 0) {
                        this.curPos += (long)n5;
                        n4 += n5;
                        n2 += n5;
                        n3 -= n5;
                        continue;
                    }
                    if (n5 != -1) continue;
                    this.blockDecoder = null;
                }
            }
            catch (IOException iOException) {
                CorruptedInputException corruptedInputException;
                if (iOException instanceof EOFException) {
                    corruptedInputException = new CorruptedInputException();
                }
                this.exception = corruptedInputException;
                if (n4 != 0) break block13;
                throw corruptedInputException;
            }
        }
        return n4;
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached || this.seekNeeded || this.blockDecoder == null) {
            return 0;
        }
        return this.blockDecoder.available();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean bl2) throws IOException {
        if (this.in != null) {
            if (this.blockDecoder != null) {
                this.blockDecoder.close();
                this.blockDecoder = null;
            }
            try {
                if (bl2) {
                    this.in.close();
                }
            }
            finally {
                this.in = null;
            }
        }
    }

    @Override
    public long length() {
        return this.uncompressedSize;
    }

    @Override
    public long position() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        return this.seekNeeded ? this.seekPos : this.curPos;
    }

    @Override
    public void seek(long l2) throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (l2 < 0L) {
            throw new XZIOException("Negative seek position: " + l2);
        }
        this.seekPos = l2;
        this.seekNeeded = true;
    }

    public void seekToBlock(int n2) throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (n2 < 0 || n2 >= this.blockCount) {
            throw new XZIOException("Invalid XZ Block number: " + n2);
        }
        this.seekPos = this.getBlockPos(n2);
        this.seekNeeded = true;
    }

    private void seek() throws IOException {
        if (!this.seekNeeded) {
            if (this.curBlockInfo.hasNext()) {
                this.curBlockInfo.setNext();
                this.initBlockDecoder();
                return;
            }
            this.seekPos = this.curPos;
        }
        this.seekNeeded = false;
        if (this.seekPos >= this.uncompressedSize) {
            this.curPos = this.seekPos;
            if (this.blockDecoder != null) {
                this.blockDecoder.close();
                this.blockDecoder = null;
            }
            this.endReached = true;
            return;
        }
        this.endReached = false;
        this.locateBlockByPos(this.curBlockInfo, this.seekPos);
        if (this.curPos <= this.curBlockInfo.uncompressedOffset || this.curPos > this.seekPos) {
            this.in.seek(this.curBlockInfo.compressedOffset);
            this.check = Check.getInstance(this.curBlockInfo.getCheckType());
            this.initBlockDecoder();
            this.curPos = this.curBlockInfo.uncompressedOffset;
        }
        if (this.seekPos > this.curPos) {
            long l2 = this.seekPos - this.curPos;
            if (this.blockDecoder.skip(l2) != l2) {
                throw new CorruptedInputException();
            }
            this.curPos = this.seekPos;
        }
    }

    private void locateBlockByPos(BlockInfo blockInfo, long l2) {
        IndexDecoder indexDecoder;
        if (l2 < 0L || l2 >= this.uncompressedSize) {
            throw new IndexOutOfBoundsException("Invalid uncompressed position: " + l2);
        }
        int n2 = 0;
        while (!(indexDecoder = this.streams.get(n2)).hasUncompressedOffset(l2)) {
            ++n2;
        }
        indexDecoder.locateBlock(blockInfo, l2);
        assert ((blockInfo.compressedOffset & 3L) == 0L);
        assert (blockInfo.uncompressedSize > 0L);
        assert (l2 >= blockInfo.uncompressedOffset);
        assert (l2 < blockInfo.uncompressedOffset + blockInfo.uncompressedSize);
    }

    private void locateBlockByNumber(BlockInfo blockInfo, int n2) {
        if (n2 < 0 || n2 >= this.blockCount) {
            throw new IndexOutOfBoundsException("Invalid XZ Block number: " + n2);
        }
        if (blockInfo.blockNumber == n2) {
            return;
        }
        int n3 = 0;
        while (true) {
            IndexDecoder indexDecoder;
            if ((indexDecoder = this.streams.get(n3)).hasRecord(n2)) {
                indexDecoder.setBlockInfo(blockInfo, n2);
                return;
            }
            ++n3;
        }
    }

    private void initBlockDecoder() throws IOException {
        try {
            if (this.blockDecoder != null) {
                this.blockDecoder.close();
                this.blockDecoder = null;
            }
            this.blockDecoder = new BlockInputStream(this.in, this.check, this.verifyCheck, this.memoryLimit, this.curBlockInfo.unpaddedSize, this.curBlockInfo.uncompressedSize, this.arrayCache);
        }
        catch (MemoryLimitException memoryLimitException) {
            assert (this.memoryLimit >= 0);
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, this.memoryLimit + this.indexMemoryUsage);
        }
        catch (IndexIndicatorException indexIndicatorException) {
            throw new CorruptedInputException();
        }
    }
}

