/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.lz.LZDecoder;
import org.tukaani.xz.lzma.LZMADecoder;
import org.tukaani.xz.rangecoder.RangeDecoderFromStream;

public class LZMAInputStream
extends InputStream {
    public static final int DICT_SIZE_MAX = 0x7FFFFFF0;
    private InputStream in;
    private ArrayCache arrayCache;
    private LZDecoder lz;
    private RangeDecoderFromStream rc;
    private LZMADecoder lzma;
    private boolean endReached = false;
    private boolean relaxedEndCondition = false;
    private final byte[] tempBuf = new byte[1];
    private long remainingSize;
    private IOException exception = null;

    public static int getMemoryUsage(int n2, byte by2) throws UnsupportedOptionsException, CorruptedInputException {
        if (n2 < 0 || n2 > 0x7FFFFFF0) {
            throw new UnsupportedOptionsException("LZMA dictionary is too big for this implementation");
        }
        int n3 = by2 & 0xFF;
        if (n3 > 224) {
            throw new CorruptedInputException("Invalid LZMA properties byte");
        }
        int n4 = (n3 %= 45) / 9;
        int n5 = n3 - n4 * 9;
        return LZMAInputStream.getMemoryUsage(n2, n5, n4);
    }

    public static int getMemoryUsage(int n2, int n3, int n4) {
        if (n3 < 0 || n3 > 8 || n4 < 0 || n4 > 4) {
            throw new IllegalArgumentException("Invalid lc or lp");
        }
        return 10 + LZMAInputStream.getDictSize(n2) / 1024 + (1536 << n3 + n4) / 1024;
    }

    private static int getDictSize(int n2) {
        if (n2 < 0 || n2 > 0x7FFFFFF0) {
            throw new IllegalArgumentException("LZMA dictionary is too big for this implementation");
        }
        if (n2 < 4096) {
            n2 = 4096;
        }
        return n2 + 15 & 0xFFFFFFF0;
    }

    public LZMAInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public LZMAInputStream(InputStream inputStream, ArrayCache arrayCache) throws IOException {
        this(inputStream, -1, arrayCache);
    }

    public LZMAInputStream(InputStream inputStream, int n2) throws IOException {
        this(inputStream, n2, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, int n2, ArrayCache arrayCache) throws IOException {
        int n3;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte by2 = dataInputStream.readByte();
        int n4 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            n4 |= dataInputStream.readUnsignedByte() << 8 * i2;
        }
        long l2 = 0L;
        for (n3 = 0; n3 < 8; ++n3) {
            l2 |= (long)dataInputStream.readUnsignedByte() << 8 * n3;
        }
        n3 = LZMAInputStream.getMemoryUsage(n4, by2);
        if (n2 != -1 && n3 > n2) {
            throw new MemoryLimitException(n3, n2);
        }
        this.initialize(inputStream, l2, by2, n4, null, arrayCache);
    }

    public LZMAInputStream(InputStream inputStream, long l2, byte by2, int n2) throws IOException {
        this.initialize(inputStream, l2, by2, n2, null, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, long l2, byte by2, int n2, byte[] byArray) throws IOException {
        this.initialize(inputStream, l2, by2, n2, byArray, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, long l2, byte by2, int n2, byte[] byArray, ArrayCache arrayCache) throws IOException {
        this.initialize(inputStream, l2, by2, n2, byArray, arrayCache);
    }

    public LZMAInputStream(InputStream inputStream, long l2, int n2, int n3, int n4, int n5, byte[] byArray) throws IOException {
        this.initialize(inputStream, l2, n2, n3, n4, n5, byArray, ArrayCache.getDefaultCache());
    }

    public LZMAInputStream(InputStream inputStream, long l2, int n2, int n3, int n4, int n5, byte[] byArray, ArrayCache arrayCache) throws IOException {
        this.initialize(inputStream, l2, n2, n3, n4, n5, byArray, arrayCache);
    }

    private void initialize(InputStream inputStream, long l2, byte by2, int n2, byte[] byArray, ArrayCache arrayCache) throws IOException {
        if (l2 < -1L) {
            throw new UnsupportedOptionsException("Uncompressed size is too big");
        }
        int n3 = by2 & 0xFF;
        if (n3 > 224) {
            throw new CorruptedInputException("Invalid LZMA properties byte");
        }
        int n4 = n3 / 45;
        int n5 = (n3 -= n4 * 9 * 5) / 9;
        int n6 = n3 - n5 * 9;
        if (n2 < 0 || n2 > 0x7FFFFFF0) {
            throw new UnsupportedOptionsException("LZMA dictionary is too big for this implementation");
        }
        this.initialize(inputStream, l2, n6, n5, n4, n2, byArray, arrayCache);
    }

    private void initialize(InputStream inputStream, long l2, int n2, int n3, int n4, int n5, byte[] byArray, ArrayCache arrayCache) throws IOException {
        if (l2 < -1L || n2 < 0 || n2 > 8 || n3 < 0 || n3 > 4 || n4 < 0 || n4 > 4) {
            throw new IllegalArgumentException();
        }
        this.in = inputStream;
        this.arrayCache = arrayCache;
        n5 = LZMAInputStream.getDictSize(n5);
        if (l2 >= 0L && (long)n5 > l2) {
            n5 = LZMAInputStream.getDictSize((int)l2);
        }
        this.lz = new LZDecoder(LZMAInputStream.getDictSize(n5), byArray, arrayCache);
        this.rc = new RangeDecoderFromStream(inputStream);
        this.lzma = new LZMADecoder(this.lz, this.rc, n2, n3, n4);
        this.remainingSize = l2;
    }

    public void enableRelaxedEndCondition() {
        this.relaxedEndCondition = true;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached) {
            return -1;
        }
        try {
            int n4 = 0;
            while (n3 > 0) {
                int n5 = n3;
                if (this.remainingSize >= 0L && this.remainingSize < (long)n3) {
                    n5 = (int)this.remainingSize;
                }
                this.lz.setLimit(n5);
                try {
                    this.lzma.decode();
                }
                catch (CorruptedInputException corruptedInputException) {
                    if (this.remainingSize != -1L || !this.lzma.endMarkerDetected()) {
                        throw corruptedInputException;
                    }
                    this.endReached = true;
                    this.rc.normalize();
                }
                int n6 = this.lz.flush(byArray, n2);
                n2 += n6;
                n3 -= n6;
                n4 += n6;
                if (this.remainingSize >= 0L) {
                    this.remainingSize -= (long)n6;
                    assert (this.remainingSize >= 0L);
                    if (this.remainingSize == 0L) {
                        this.endReached = true;
                    }
                }
                if (!this.endReached) continue;
                if (this.lz.hasPending() || !this.relaxedEndCondition && !this.rc.isFinished()) {
                    throw new CorruptedInputException();
                }
                this.putArraysToCache();
                return n4 == 0 ? -1 : n4;
            }
            return n4;
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    private void putArraysToCache() {
        if (this.lz != null) {
            this.lz.putArraysToCache(this.arrayCache);
            this.lz = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.putArraysToCache();
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }
}

