/*
 * Decompiled with CFR 0.152.
 */
package org.blockbuster.render;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderManager;

public class BloomEffect {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static int LAST_WIDTH;
    private static int LAST_HEIGHT;
    private static Framebuffer INPUT;
    private static Framebuffer OUTPUT;
    private static Framebuffer SWAP2A;
    private static Framebuffer SWAP4A;
    private static Framebuffer SWAP8A;
    private static Framebuffer SWAP2B;
    private static Framebuffer SWAP4B;
    private static Framebuffer SWAP8B;
    private static final ShaderManager SEPARABLE_BLUR;
    private static final ShaderManager UNREAL_COMPOSITE;
    public static final ShaderManager BLIT_SHADER;
    private static int LAST_WIDTH1;
    private static int LAST_HEIGHT1;

    private static ShaderManager loadShader(String shaderName) {
        try {
            return new ShaderManager(Minecraft.func_71410_x().func_110442_L(), shaderName);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static Framebuffer getInput() {
        if (INPUT == null) {
            INPUT = BloomEffect.resize(null, BloomEffect.MC.func_147110_a().field_147621_c, BloomEffect.MC.func_147110_a().field_147618_d, true);
            BloomEffect.hookDepthBuffer(INPUT, BloomEffect.MC.func_147110_a().field_147624_h);
        }
        return INPUT;
    }

    public static Framebuffer getOutput() {
        int width = BloomEffect.MC.func_147110_a().field_147621_c;
        int height = BloomEffect.MC.func_147110_a().field_147618_d;
        if (LAST_WIDTH1 != width || LAST_HEIGHT1 != height) {
            OUTPUT = BloomEffect.resize(OUTPUT, width, height, false);
            LAST_WIDTH1 = width;
            LAST_HEIGHT1 = height;
        }
        return OUTPUT;
    }

    public static void hookDepthBuffer(Framebuffer fbo, int depthBuffer) {
        fbo.func_147610_a(false);
        OpenGlHelper.func_153176_h((int)OpenGlHelper.field_153199_f, (int)depthBuffer);
        if (!fbo.isStencilEnabled()) {
            OpenGlHelper.func_153186_a((int)OpenGlHelper.field_153199_f, (int)33190, (int)fbo.field_147622_a, (int)fbo.field_147620_b);
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)OpenGlHelper.field_153199_f, (int)depthBuffer);
        } else {
            OpenGlHelper.func_153186_a((int)OpenGlHelper.field_153199_f, (int)35056, (int)fbo.field_147622_a, (int)fbo.field_147620_b);
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36096, (int)OpenGlHelper.field_153199_f, (int)depthBuffer);
            OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36128, (int)OpenGlHelper.field_153199_f, (int)depthBuffer);
        }
    }

    public static void updateScreenSize(int width, int height) {
        if (LAST_WIDTH == width && LAST_HEIGHT == height) {
            return;
        }
        INPUT = BloomEffect.resize(null, width, height, true);
        BloomEffect.hookDepthBuffer(INPUT, BloomEffect.MC.func_147110_a().field_147624_h);
        OUTPUT = BloomEffect.resize(OUTPUT, width, height, false);
        SWAP2A = BloomEffect.resize(SWAP2A, width / 2, height / 2, false);
        SWAP4A = BloomEffect.resize(SWAP4A, width / 4, height / 4, false);
        SWAP8A = BloomEffect.resize(SWAP8A, width / 8, height / 8, false);
        SWAP2B = BloomEffect.resize(SWAP2B, width / 2, height / 2, false);
        SWAP4B = BloomEffect.resize(SWAP4B, width / 4, height / 4, false);
        SWAP8B = BloomEffect.resize(SWAP8B, width / 8, height / 8, false);
        LAST_WIDTH = width;
        LAST_HEIGHT = height;
    }

    private static Framebuffer resize(@Nullable Framebuffer target, int width, int height, boolean useDepth) {
        if (target == null) {
            target = new Framebuffer(width, height, useDepth);
            target.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        }
        target.func_147613_a(width, height);
        target.func_147607_a(9729);
        return target;
    }

    public static void renderBloom(int width, int height, int background, int input, Framebuffer output) {
        BloomEffect.updateScreenSize(width, height);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)GlStateManager.SourceFactor.SRC_ALPHA.field_187395_p, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_187345_o, (int)GlStateManager.SourceFactor.ONE.field_187395_p, (int)GlStateManager.DestFactor.ZERO.field_187345_o);
        SEPARABLE_BLUR.func_147992_a("DiffuseSampler", (Object)input);
        SEPARABLE_BLUR.func_147984_b("BlurDir").func_148087_a(1.0f, 0.0f);
        SEPARABLE_BLUR.func_147984_b("Radius").func_148083_a(3, 0, 0, 0);
        SEPARABLE_BLUR.func_147984_b("OutSize").func_148087_a((float)BloomEffect.SWAP2A.field_147621_c, (float)BloomEffect.SWAP2A.field_147618_d);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP2A);
        SEPARABLE_BLUR.func_147992_a("DiffuseSampler", (Object)SWAP2A);
        SEPARABLE_BLUR.func_147984_b("BlurDir").func_148087_a(0.0f, 1.0f);
        SEPARABLE_BLUR.func_147984_b("Radius").func_148083_a(3, 0, 0, 0);
        SEPARABLE_BLUR.func_147984_b("OutSize").func_148087_a((float)BloomEffect.SWAP2B.field_147621_c, (float)BloomEffect.SWAP2B.field_147618_d);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP2B);
        SEPARABLE_BLUR.func_147992_a("DiffuseSampler", (Object)SWAP2B);
        SEPARABLE_BLUR.func_147984_b("BlurDir").func_148087_a(1.0f, 0.0f);
        SEPARABLE_BLUR.func_147984_b("Radius").func_148083_a(5, 0, 0, 0);
        SEPARABLE_BLUR.func_147984_b("OutSize").func_148087_a((float)BloomEffect.SWAP4A.field_147621_c, (float)BloomEffect.SWAP4A.field_147618_d);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP4A);
        SEPARABLE_BLUR.func_147992_a("DiffuseSampler", (Object)SWAP4A);
        SEPARABLE_BLUR.func_147984_b("BlurDir").func_148087_a(0.0f, 1.0f);
        SEPARABLE_BLUR.func_147984_b("Radius").func_148083_a(5, 0, 0, 0);
        SEPARABLE_BLUR.func_147984_b("OutSize").func_148087_a((float)BloomEffect.SWAP4B.field_147621_c, (float)BloomEffect.SWAP4B.field_147618_d);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP4B);
        SEPARABLE_BLUR.func_147992_a("DiffuseSampler", (Object)SWAP4B);
        SEPARABLE_BLUR.func_147984_b("BlurDir").func_148087_a(1.0f, 0.0f);
        SEPARABLE_BLUR.func_147984_b("Radius").func_148083_a(7, 0, 0, 0);
        SEPARABLE_BLUR.func_147984_b("OutSize").func_148087_a((float)BloomEffect.SWAP8A.field_147621_c, (float)BloomEffect.SWAP8A.field_147618_d);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP8A);
        SEPARABLE_BLUR.func_147992_a("DiffuseSampler", (Object)SWAP8A);
        SEPARABLE_BLUR.func_147984_b("BlurDir").func_148087_a(0.0f, 1.0f);
        SEPARABLE_BLUR.func_147984_b("Radius").func_148083_a(7, 0, 0, 0);
        SEPARABLE_BLUR.func_147984_b("OutSize").func_148087_a((float)BloomEffect.SWAP8B.field_147621_c, (float)BloomEffect.SWAP8B.field_147618_d);
        BloomEffect.blitShader(SEPARABLE_BLUR, SWAP8B);
        UNREAL_COMPOSITE.func_147992_a("DiffuseSampler", (Object)background);
        UNREAL_COMPOSITE.func_147992_a("HighLight", (Object)input);
        UNREAL_COMPOSITE.func_147992_a("BlurTexture1", (Object)SWAP2B);
        UNREAL_COMPOSITE.func_147992_a("BlurTexture2", (Object)SWAP4B);
        UNREAL_COMPOSITE.func_147992_a("BlurTexture3", (Object)SWAP8B);
        UNREAL_COMPOSITE.func_147984_b("BloomRadius").func_148090_a(1.0f);
        BloomEffect.blitShader(UNREAL_COMPOSITE, output);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
    }

    public static void blitShader(ShaderManager shaderInstance, Framebuffer dist) {
        dist.func_147614_f();
        dist.func_147610_a(false);
        shaderInstance.func_147995_c();
        GlStateManager.func_179129_p();
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tesselator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b(-1.0, 1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(-1.0, -1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(1.0, -1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(1.0, 1.0, 0.0).func_181675_d();
        tesselator.func_78381_a();
        shaderInstance.func_147993_b();
    }

    static {
        SEPARABLE_BLUR = BloomEffect.loadShader("dragoncore:separable_blur");
        UNREAL_COMPOSITE = BloomEffect.loadShader("dragoncore:unreal_composite");
        BLIT_SHADER = BloomEffect.loadShader("dragoncore:fast_blit");
    }
}

