/*
 * Decompiled with CFR 0.152.
 */
package org.blockbuster.math.molang.expressions;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import org.blockbuster.math.Constant;
import org.blockbuster.math.Operation;
import org.blockbuster.math.molang.MolangParser;
import org.blockbuster.math.molang.expressions.MolangValue;

public abstract class MolangExpression {
    public MolangParser context;

    public static boolean isZero(MolangExpression expression) {
        return MolangExpression.isConstant(expression, 0.0);
    }

    public static boolean isOne(MolangExpression expression) {
        return MolangExpression.isConstant(expression, 1.0);
    }

    public static boolean isConstant(MolangExpression expression, double x2) {
        if (expression instanceof MolangValue) {
            MolangValue value = (MolangValue)expression;
            return value.value instanceof Constant && Operation.equals(value.value.get().doubleValue(), x2);
        }
        return false;
    }

    public static boolean isExpressionConstant(MolangExpression expression) {
        if (expression instanceof MolangValue) {
            MolangValue value = (MolangValue)expression;
            return value.value instanceof Constant;
        }
        return false;
    }

    public MolangExpression(MolangParser context) {
        this.context = context;
    }

    public abstract double get();

    public JsonElement toJson() {
        return new JsonPrimitive(this.toString());
    }
}

