/*
 * Decompiled with CFR 0.152.
 */
package org.blockbuster.components.meta;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.blockbuster.components.BedrockComponentBase;
import org.blockbuster.components.IComponentParticleInitialize;
import org.blockbuster.emitter.BedrockEmitter;
import org.blockbuster.emitter.BedrockParticle;
import org.blockbuster.math.molang.MolangException;
import org.blockbuster.math.molang.MolangParser;

public class BedrockComponentLocalSpace
extends BedrockComponentBase
implements IComponentParticleInitialize {
    public boolean position;
    public boolean rotation;

    @Override
    public BedrockComponentBase fromJson(JsonElement elem, MolangParser parser) throws MolangException {
        if (!elem.isJsonObject()) {
            return super.fromJson(elem, parser);
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("position")) {
            this.position = element.get("position").getAsBoolean();
        }
        if (element.has("rotation")) {
            this.rotation = element.get("rotation").getAsBoolean();
        }
        return super.fromJson((JsonElement)element, parser);
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        if (this.position) {
            object.addProperty("position", Boolean.valueOf(true));
        }
        if (this.rotation) {
            object.addProperty("rotation", Boolean.valueOf(true));
        }
        return object;
    }

    @Override
    public void apply(BedrockEmitter emitter, BedrockParticle particle) {
        particle.relativePosition = this.position;
        particle.relativeRotation = this.rotation || emitter.isModelParticle;
        particle.setupMatrix(emitter);
    }

    @Override
    public int getSortingIndex() {
        return 6;
    }
}

