/*
 * Decompiled with CFR 0.152.
 */
package org.blockbuster.components.lifetime;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.blockbuster.components.BedrockComponentBase;
import org.blockbuster.components.lifetime.BedrockComponentLifetime;
import org.blockbuster.emitter.BedrockEmitter;
import org.blockbuster.math.molang.MolangException;
import org.blockbuster.math.molang.MolangParser;
import org.blockbuster.math.molang.expressions.MolangExpression;

public class BedrockComponentLifetimeLooping
extends BedrockComponentLifetime {
    public MolangExpression sleepTime = MolangParser.ZERO;

    @Override
    public BedrockComponentBase fromJson(JsonElement elem, MolangParser parser) throws MolangException {
        if (!elem.isJsonObject()) {
            return super.fromJson(elem, parser);
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("sleep_time")) {
            this.sleepTime = parser.parseJson(element.get("sleep_time"));
        }
        return super.fromJson((JsonElement)element, parser);
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = (JsonObject)super.toJson();
        if (!MolangExpression.isZero(this.sleepTime)) {
            object.add("sleep_time", this.sleepTime.toJson());
        }
        return object;
    }

    @Override
    public void update(BedrockEmitter emitter) {
        double active = this.activeTime.get();
        double sleep = this.sleepTime.get();
        double age = emitter.getAge();
        emitter.lifetime = (int)(active * 20.0);
        if (age >= active && emitter.playing) {
            emitter.stop();
        }
        if (age >= sleep && !emitter.playing) {
            emitter.start();
        }
    }
}

