/*
 * Decompiled with CFR 0.152.
 */
package org.blockbuster.components.lifetime;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.blockbuster.components.BedrockComponentBase;
import org.blockbuster.components.lifetime.BedrockComponentLifetime;
import org.blockbuster.emitter.BedrockEmitter;
import org.blockbuster.math.Operation;
import org.blockbuster.math.molang.MolangException;
import org.blockbuster.math.molang.MolangParser;
import org.blockbuster.math.molang.expressions.MolangExpression;

public class BedrockComponentLifetimeExpression
extends BedrockComponentLifetime {
    public MolangExpression expiration = MolangParser.ZERO;

    @Override
    protected String getPropertyName() {
        return "activation_expression";
    }

    @Override
    public BedrockComponentBase fromJson(JsonElement elem, MolangParser parser) throws MolangException {
        if (!elem.isJsonObject()) {
            return super.fromJson(elem, parser);
        }
        JsonObject element = elem.getAsJsonObject();
        if (element.has("expiration_expression")) {
            this.expiration = parser.parseJson(element.get("expiration_expression"));
        }
        return super.fromJson((JsonElement)element, parser);
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = (JsonObject)super.toJson();
        if (!MolangExpression.isZero(this.expiration)) {
            object.add("expiration_expression", this.expiration.toJson());
        }
        return object;
    }

    @Override
    public void update(BedrockEmitter emitter) {
        if (!Operation.equals(this.activeTime.get(), 0.0)) {
            emitter.start();
        }
        if (!Operation.equals(this.expiration.get(), 0.0)) {
            emitter.stop();
        }
    }
}

