/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketBuffer
extends net.minecraft.network.PacketBuffer {
    private final ByteBuf buf;

    public PacketBuffer(ByteBuf a2) {
        super(a2);
        PacketBuffer a3;
        a3.buf = a2;
    }

    public static int getVarIntSize(int a2) {
        for (int a3 = 1; a3 < 5; ++a3) {
            if ((a2 & -1 << a3 * 7) != 0) continue;
            return a3;
        }
        return 5;
    }

    public PacketBuffer writeByteArray(byte[] a2) {
        PacketBuffer a3;
        a3.writeVarInt(a2.length);
        a3.writeBytes(a2);
        return a3;
    }

    public byte[] func_179251_a() {
        PacketBuffer a2;
        return a2.func_189425_b(a2.readableBytes());
    }

    public byte[] func_189425_b(int a2) {
        PacketBuffer a3;
        int a4 = a3.func_150792_a();
        if (a4 > a2) {
            throw new DecoderException("ByteArray with size " + a4 + " is bigger than allowed " + a2);
        }
        byte[] a5 = new byte[a4];
        a3.readBytes(a5);
        return a5;
    }

    public PacketBuffer writeVarIntArray(int[] a2) {
        PacketBuffer a3;
        a3.writeVarInt(a2.length);
        for (int a4 : a2) {
            a3.writeVarInt(a4);
        }
        return a3;
    }

    public int[] func_186863_b() {
        PacketBuffer a2;
        return a2.func_189424_c(a2.readableBytes());
    }

    public int[] func_189424_c(int a2) {
        PacketBuffer a3;
        int a4 = a3.func_150792_a();
        if (a4 > a2) {
            throw new DecoderException("VarIntArray with size " + a4 + " is bigger than allowed " + a2);
        }
        int[] a5 = new int[a4];
        for (int a6 = 0; a6 < a5.length; ++a6) {
            a5[a6] = a3.func_150792_a();
        }
        return a5;
    }

    public PacketBuffer writeLongArray(long[] a2) {
        PacketBuffer a3;
        a3.writeVarInt(a2.length);
        for (long a4 : a2) {
            a3.writeLong(a4);
        }
        return a3;
    }

    @SideOnly(value=Side.CLIENT)
    public long[] func_186873_b(@Nullable long[] a2) {
        return this.func_189423_a(a2, this.readableBytes() / 8);
    }

    @SideOnly(value=Side.CLIENT)
    public long[] func_189423_a(@Nullable long[] array, int a2) {
        int a3 = this.func_150792_a();
        if (array == null || array.length != a3) {
            if (a3 > a2) {
                throw new DecoderException("LongArray with size " + a3 + " is bigger than allowed " + a2);
            }
            array = new long[a3];
        }
        for (int a4 = 0; a4 < array.length; ++a4) {
            array[a4] = this.readLong();
        }
        return array;
    }

    public BlockPos func_179259_c() {
        PacketBuffer a2;
        return BlockPos.func_177969_a((long)a2.readLong());
    }

    public PacketBuffer writeBlockPos(BlockPos a2) {
        PacketBuffer a3;
        a3.writeLong(a2.func_177986_g());
        return a3;
    }

    public ITextComponent func_179258_d() throws IOException {
        PacketBuffer a2;
        return ITextComponent.Serializer.func_150699_a((String)a2.func_150789_c(Short.MAX_VALUE));
    }

    public PacketBuffer writeTextComponent(ITextComponent a2) {
        PacketBuffer a3;
        return a3.writeString(ITextComponent.Serializer.func_150696_a((ITextComponent)a2));
    }

    public <T extends Enum<T>> T func_179257_a(Class<T> a2) {
        PacketBuffer a3;
        return (T)((Enum[])a2.getEnumConstants())[a3.func_150792_a()];
    }

    public PacketBuffer writeEnumValue(Enum<?> a2) {
        PacketBuffer a3;
        return a3.writeVarInt(a2.ordinal());
    }

    public int func_150792_a() {
        byte a2;
        int a3 = 0;
        int a4 = 0;
        do {
            PacketBuffer a5;
            a2 = a5.readByte();
            a3 |= (a2 & 0x7F) << a4++ * 7;
            if (a4 <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((a2 & 0x80) == 128);
        return a3;
    }

    public long func_179260_f() {
        byte a2;
        long a3 = 0L;
        int a4 = 0;
        do {
            PacketBuffer a5;
            a2 = a5.readByte();
            a3 |= (long)(a2 & 0x7F) << a4++ * 7;
            if (a4 <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((a2 & 0x80) == 128);
        return a3;
    }

    public PacketBuffer writeUniqueId(UUID a2) {
        PacketBuffer a3;
        a3.writeLong(a2.getMostSignificantBits());
        a3.writeLong(a2.getLeastSignificantBits());
        return a3;
    }

    public UUID func_179253_g() {
        PacketBuffer a2;
        return new UUID(a2.readLong(), a2.readLong());
    }

    public PacketBuffer writeVarInt(int a2) {
        PacketBuffer a3;
        while ((a2 & 0xFFFFFF80) != 0) {
            a3.writeByte(a2 & 0x7F | 0x80);
            a2 >>>= 7;
        }
        a3.writeByte(a2);
        return a3;
    }

    public PacketBuffer writeVarLong(long a2) {
        PacketBuffer a3;
        while ((a2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            a3.writeByte((int)(a2 & 0x7FL) | 0x80);
            a2 >>>= 7;
        }
        a3.writeByte((int)a2);
        return a3;
    }

    public PacketBuffer writeCompoundTag(@Nullable NBTTagCompound a2) {
        if (a2 == null) {
            this.writeByte(0);
        } else {
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)a2, (DataOutput)new ByteBufOutputStream((ByteBuf)this));
            }
            catch (IOException a3) {
                throw new EncoderException((Throwable)a3);
            }
        }
        return this;
    }

    @Nullable
    public NBTTagCompound func_150793_b() throws IOException {
        PacketBuffer a2;
        int a3 = a2.readerIndex();
        byte a4 = a2.readByte();
        if (a4 == 0) {
            return null;
        }
        a2.readerIndex(a3);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)a2), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException a5) {
            throw new EncoderException((Throwable)a5);
        }
    }

    public PacketBuffer writeItemStack(ItemStack a2) {
        PacketBuffer a3;
        if (a2.func_190926_b()) {
            a3.writeShort(-1);
        } else {
            a3.writeShort(Item.func_150891_b((Item)a2.func_77973_b()));
            a3.writeByte(a2.func_190916_E());
            a3.writeShort(a2.func_77960_j());
            NBTTagCompound a4 = null;
            if (a2.func_77973_b().func_77645_m() || a2.func_77973_b().func_77651_p()) {
                a4 = a2.func_77973_b().getNBTShareTag(a2);
            }
            a3.writeCompoundTag(a4);
        }
        return a3;
    }

    public ItemStack func_150791_c() throws IOException {
        PacketBuffer a2;
        short a3 = a2.readShort();
        if (a3 < 0) {
            return ItemStack.field_190927_a;
        }
        short a4 = a2.readByte();
        if (a4 == -8) {
            a4 = a2.readShort();
        }
        short a5 = a2.readShort();
        ItemStack a6 = new ItemStack(Item.func_150899_d((int)a3), (int)a4, (int)a5);
        a6.func_77973_b().readNBTShareTag(a6, a2.func_150793_b());
        return a6;
    }

    public String func_150789_c(int a2) {
        PacketBuffer a3;
        return a3.readString();
    }

    public String readString() {
        PacketBuffer a2;
        int a3 = a2.readInt();
        if (a3 < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String a4 = a2.toString(a2.readerIndex(), a3, StandardCharsets.UTF_8);
        a2.readerIndex(a2.readerIndex() + a3);
        return a4;
    }

    public PacketBuffer writeString(String a2) {
        PacketBuffer a3;
        byte[] a4 = a2.getBytes(StandardCharsets.UTF_8);
        if (a4.length > Short.MAX_VALUE) {
            throw new EncoderException("String too big (was " + a4.length + " bytes encoded, max " + Short.MAX_VALUE + ")");
        }
        a3.writeVarInt(a4.length);
        a3.writeBytes(a4);
        return a3;
    }

    public ResourceLocation func_192575_l() {
        PacketBuffer a2;
        return new ResourceLocation(a2.func_150789_c(Short.MAX_VALUE));
    }

    public PacketBuffer writeResourceLocation(ResourceLocation a2) {
        PacketBuffer a3;
        a3.writeString(a2.toString());
        return a3;
    }

    public Date func_192573_m() {
        PacketBuffer a2;
        return new Date(a2.readLong());
    }

    public PacketBuffer writeTime(Date a2) {
        PacketBuffer a3;
        a3.writeLong(a2.getTime());
        return a3;
    }

    public int capacity() {
        PacketBuffer a2;
        return a2.buf.capacity();
    }

    public ByteBuf capacity(int a2) {
        PacketBuffer a3;
        return a3.buf.capacity(a2);
    }

    public int maxCapacity() {
        PacketBuffer a2;
        return a2.buf.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        PacketBuffer a2;
        return a2.buf.alloc();
    }

    public ByteOrder order() {
        PacketBuffer a2;
        return a2.buf.order();
    }

    public ByteBuf order(ByteOrder a2) {
        PacketBuffer a3;
        return a3.buf.order(a2);
    }

    public ByteBuf unwrap() {
        PacketBuffer a2;
        return a2.buf.unwrap();
    }

    public boolean isDirect() {
        PacketBuffer a2;
        return a2.buf.isDirect();
    }

    public boolean isReadOnly() {
        PacketBuffer a2;
        return a2.buf.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        PacketBuffer a2;
        return a2.buf.asReadOnly();
    }

    public int readerIndex() {
        PacketBuffer a2;
        return a2.buf.readerIndex();
    }

    public ByteBuf readerIndex(int a2) {
        PacketBuffer a3;
        return a3.buf.readerIndex(a2);
    }

    public int writerIndex() {
        PacketBuffer a2;
        return a2.buf.writerIndex();
    }

    public ByteBuf writerIndex(int a2) {
        PacketBuffer a3;
        return a3.buf.writerIndex(a2);
    }

    public ByteBuf setIndex(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setIndex(a2, a3);
    }

    public int readableBytes() {
        PacketBuffer a2;
        return a2.buf.readableBytes();
    }

    public int writableBytes() {
        PacketBuffer a2;
        return a2.buf.writableBytes();
    }

    public int maxWritableBytes() {
        PacketBuffer a2;
        return a2.buf.maxWritableBytes();
    }

    public boolean isReadable() {
        PacketBuffer a2;
        return a2.buf.isReadable();
    }

    public boolean isReadable(int a2) {
        PacketBuffer a3;
        return a3.buf.isReadable(a2);
    }

    public boolean isWritable() {
        PacketBuffer a2;
        return a2.buf.isWritable();
    }

    public boolean isWritable(int a2) {
        PacketBuffer a3;
        return a3.buf.isWritable(a2);
    }

    public ByteBuf clear() {
        PacketBuffer a2;
        return a2.buf.clear();
    }

    public ByteBuf markReaderIndex() {
        PacketBuffer a2;
        return a2.buf.markReaderIndex();
    }

    public ByteBuf resetReaderIndex() {
        PacketBuffer a2;
        return a2.buf.resetReaderIndex();
    }

    public ByteBuf markWriterIndex() {
        PacketBuffer a2;
        return a2.buf.markWriterIndex();
    }

    public ByteBuf resetWriterIndex() {
        PacketBuffer a2;
        return a2.buf.resetWriterIndex();
    }

    public ByteBuf discardReadBytes() {
        PacketBuffer a2;
        return a2.buf.discardReadBytes();
    }

    public ByteBuf discardSomeReadBytes() {
        PacketBuffer a2;
        return a2.buf.discardSomeReadBytes();
    }

    public ByteBuf ensureWritable(int a2) {
        PacketBuffer a3;
        return a3.buf.ensureWritable(a2);
    }

    public int ensureWritable(int a2, boolean a3) {
        PacketBuffer a4;
        return a4.buf.ensureWritable(a2, a3);
    }

    public boolean getBoolean(int a2) {
        PacketBuffer a3;
        return a3.buf.getBoolean(a2);
    }

    public byte getByte(int a2) {
        PacketBuffer a3;
        return a3.buf.getByte(a2);
    }

    public short getUnsignedByte(int a2) {
        PacketBuffer a3;
        return a3.buf.getUnsignedByte(a2);
    }

    public short getShort(int a2) {
        PacketBuffer a3;
        return a3.buf.getShort(a2);
    }

    public short getShortLE(int a2) {
        PacketBuffer a3;
        return a3.buf.getShortLE(a2);
    }

    public int getUnsignedShort(int a2) {
        PacketBuffer a3;
        return a3.buf.getUnsignedShort(a2);
    }

    public int getUnsignedShortLE(int a2) {
        PacketBuffer a3;
        return a3.buf.getUnsignedShortLE(a2);
    }

    public int getMedium(int a2) {
        PacketBuffer a3;
        return a3.buf.getMedium(a2);
    }

    public int getMediumLE(int a2) {
        PacketBuffer a3;
        return a3.buf.getMediumLE(a2);
    }

    public int getUnsignedMedium(int a2) {
        PacketBuffer a3;
        return a3.buf.getUnsignedMedium(a2);
    }

    public int getUnsignedMediumLE(int a2) {
        PacketBuffer a3;
        return a3.buf.getUnsignedMediumLE(a2);
    }

    public int getInt(int a2) {
        PacketBuffer a3;
        return a3.buf.getInt(a2);
    }

    public int getIntLE(int a2) {
        PacketBuffer a3;
        return a3.buf.getIntLE(a2);
    }

    public long getUnsignedInt(int a2) {
        PacketBuffer a3;
        return a3.buf.getUnsignedInt(a2);
    }

    public long getUnsignedIntLE(int a2) {
        PacketBuffer a3;
        return a3.buf.getUnsignedIntLE(a2);
    }

    public long getLong(int a2) {
        PacketBuffer a3;
        return a3.buf.getLong(a2);
    }

    public long getLongLE(int a2) {
        PacketBuffer a3;
        return a3.buf.getLongLE(a2);
    }

    public char getChar(int a2) {
        PacketBuffer a3;
        return a3.buf.getChar(a2);
    }

    public float getFloat(int a2) {
        PacketBuffer a3;
        return a3.buf.getFloat(a2);
    }

    public double getDouble(int a2) {
        PacketBuffer a3;
        return a3.buf.getDouble(a2);
    }

    public ByteBuf getBytes(int a2, ByteBuf a3) {
        PacketBuffer a4;
        return a4.buf.getBytes(a2, a3);
    }

    public ByteBuf getBytes(int a2, ByteBuf a3, int a4) {
        PacketBuffer a5;
        return a5.buf.getBytes(a2, a3, a4);
    }

    public ByteBuf getBytes(int a2, ByteBuf a3, int a4, int a5) {
        PacketBuffer a6;
        return a6.buf.getBytes(a2, a3, a4, a5);
    }

    public ByteBuf getBytes(int a2, byte[] a3) {
        PacketBuffer a4;
        return a4.buf.getBytes(a2, a3);
    }

    public ByteBuf getBytes(int a2, byte[] a3, int a4, int a5) {
        PacketBuffer a6;
        return a6.buf.getBytes(a2, a3, a4, a5);
    }

    public ByteBuf getBytes(int a2, ByteBuffer a3) {
        PacketBuffer a4;
        return a4.buf.getBytes(a2, a3);
    }

    public ByteBuf getBytes(int a2, OutputStream a3, int a4) throws IOException {
        PacketBuffer a5;
        return a5.buf.getBytes(a2, a3, a4);
    }

    public int getBytes(int a2, GatheringByteChannel a3, int a4) throws IOException {
        PacketBuffer a5;
        return a5.buf.getBytes(a2, a3, a4);
    }

    public int getBytes(int a2, FileChannel a3, long a4, int a5) throws IOException {
        PacketBuffer a6;
        return a6.buf.getBytes(a2, a3, a4, a5);
    }

    public CharSequence getCharSequence(int a2, int a3, Charset a4) {
        PacketBuffer a5;
        return a5.buf.getCharSequence(a2, a3, a4);
    }

    public ByteBuf setBoolean(int a2, boolean a3) {
        PacketBuffer a4;
        return a4.buf.setBoolean(a2, a3);
    }

    public ByteBuf setByte(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setByte(a2, a3);
    }

    public ByteBuf setShort(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setShort(a2, a3);
    }

    public ByteBuf setShortLE(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setShortLE(a2, a3);
    }

    public ByteBuf setMedium(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setMedium(a2, a3);
    }

    public ByteBuf setMediumLE(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setMediumLE(a2, a3);
    }

    public ByteBuf setInt(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setInt(a2, a3);
    }

    public ByteBuf setIntLE(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setIntLE(a2, a3);
    }

    public ByteBuf setLong(int a2, long a3) {
        PacketBuffer a4;
        return a4.buf.setLong(a2, a3);
    }

    public ByteBuf setLongLE(int a2, long a3) {
        PacketBuffer a4;
        return a4.buf.setLongLE(a2, a3);
    }

    public ByteBuf setChar(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setChar(a2, a3);
    }

    public ByteBuf setFloat(int a2, float a3) {
        PacketBuffer a4;
        return a4.buf.setFloat(a2, a3);
    }

    public ByteBuf setDouble(int a2, double a3) {
        PacketBuffer a4;
        return a4.buf.setDouble(a2, a3);
    }

    public ByteBuf setBytes(int a2, ByteBuf a3) {
        PacketBuffer a4;
        return a4.buf.setBytes(a2, a3);
    }

    public ByteBuf setBytes(int a2, ByteBuf a3, int a4) {
        PacketBuffer a5;
        return a5.buf.setBytes(a2, a3, a4);
    }

    public ByteBuf setBytes(int a2, ByteBuf a3, int a4, int a5) {
        PacketBuffer a6;
        return a6.buf.setBytes(a2, a3, a4, a5);
    }

    public ByteBuf setBytes(int a2, byte[] a3) {
        PacketBuffer a4;
        return a4.buf.setBytes(a2, a3);
    }

    public ByteBuf setBytes(int a2, byte[] a3, int a4, int a5) {
        PacketBuffer a6;
        return a6.buf.setBytes(a2, a3, a4, a5);
    }

    public ByteBuf setBytes(int a2, ByteBuffer a3) {
        PacketBuffer a4;
        return a4.buf.setBytes(a2, a3);
    }

    public int setBytes(int a2, InputStream a3, int a4) throws IOException {
        PacketBuffer a5;
        return a5.buf.setBytes(a2, a3, a4);
    }

    public int setBytes(int a2, ScatteringByteChannel a3, int a4) throws IOException {
        PacketBuffer a5;
        return a5.buf.setBytes(a2, a3, a4);
    }

    public int setBytes(int a2, FileChannel a3, long a4, int a5) throws IOException {
        PacketBuffer a6;
        return a6.buf.setBytes(a2, a3, a4, a5);
    }

    public ByteBuf setZero(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.setZero(a2, a3);
    }

    public int setCharSequence(int a2, CharSequence a3, Charset a4) {
        PacketBuffer a5;
        return a5.buf.setCharSequence(a2, a3, a4);
    }

    public boolean readBoolean() {
        PacketBuffer a2;
        return a2.buf.readBoolean();
    }

    public byte readByte() {
        PacketBuffer a2;
        return a2.buf.readByte();
    }

    public short readUnsignedByte() {
        PacketBuffer a2;
        return a2.buf.readUnsignedByte();
    }

    public short readShort() {
        PacketBuffer a2;
        return a2.buf.readShort();
    }

    public short readShortLE() {
        PacketBuffer a2;
        return a2.buf.readShortLE();
    }

    public int readUnsignedShort() {
        PacketBuffer a2;
        return a2.buf.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        PacketBuffer a2;
        return a2.buf.readUnsignedShortLE();
    }

    public int readMedium() {
        PacketBuffer a2;
        return a2.buf.readMedium();
    }

    public int readMediumLE() {
        PacketBuffer a2;
        return a2.buf.readMediumLE();
    }

    public int readUnsignedMedium() {
        PacketBuffer a2;
        return a2.buf.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        PacketBuffer a2;
        return a2.buf.readUnsignedMediumLE();
    }

    public int readInt() {
        PacketBuffer a2;
        return a2.buf.readInt();
    }

    public int readIntLE() {
        PacketBuffer a2;
        return a2.buf.readIntLE();
    }

    public long readUnsignedInt() {
        PacketBuffer a2;
        return a2.buf.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        PacketBuffer a2;
        return a2.buf.readUnsignedIntLE();
    }

    public long readLong() {
        PacketBuffer a2;
        return a2.buf.readLong();
    }

    public long readLongLE() {
        PacketBuffer a2;
        return a2.buf.readLongLE();
    }

    public char readChar() {
        PacketBuffer a2;
        return a2.buf.readChar();
    }

    public float readFloat() {
        PacketBuffer a2;
        return a2.buf.readFloat();
    }

    public double readDouble() {
        PacketBuffer a2;
        return a2.buf.readDouble();
    }

    public ByteBuf readBytes(int a2) {
        PacketBuffer a3;
        return a3.buf.readBytes(a2);
    }

    public ByteBuf readSlice(int a2) {
        PacketBuffer a3;
        return a3.buf.readSlice(a2);
    }

    public ByteBuf readRetainedSlice(int a2) {
        PacketBuffer a3;
        return a3.buf.readRetainedSlice(a2);
    }

    public ByteBuf readBytes(ByteBuf a2) {
        PacketBuffer a3;
        return a3.buf.readBytes(a2);
    }

    public ByteBuf readBytes(ByteBuf a2, int a3) {
        PacketBuffer a4;
        return a4.buf.readBytes(a2, a3);
    }

    public ByteBuf readBytes(ByteBuf a2, int a3, int a4) {
        PacketBuffer a5;
        return a5.buf.readBytes(a2, a3, a4);
    }

    public ByteBuf readBytes(byte[] a2) {
        PacketBuffer a3;
        return a3.buf.readBytes(a2);
    }

    public ByteBuf readBytes(byte[] a2, int a3, int a4) {
        PacketBuffer a5;
        return a5.buf.readBytes(a2, a3, a4);
    }

    public ByteBuf readBytes(ByteBuffer a2) {
        PacketBuffer a3;
        return a3.buf.readBytes(a2);
    }

    public ByteBuf readBytes(OutputStream a2, int a3) throws IOException {
        PacketBuffer a4;
        return a4.buf.readBytes(a2, a3);
    }

    public int readBytes(GatheringByteChannel a2, int a3) throws IOException {
        PacketBuffer a4;
        return a4.buf.readBytes(a2, a3);
    }

    public CharSequence readCharSequence(int a2, Charset a3) {
        PacketBuffer a4;
        return a4.buf.readCharSequence(a2, a3);
    }

    public int readBytes(FileChannel a2, long a3, int a4) throws IOException {
        PacketBuffer a5;
        return a5.buf.readBytes(a2, a3, a4);
    }

    public ByteBuf skipBytes(int a2) {
        PacketBuffer a3;
        return a3.buf.skipBytes(a2);
    }

    public ByteBuf writeBoolean(boolean a2) {
        PacketBuffer a3;
        return a3.buf.writeBoolean(a2);
    }

    public ByteBuf writeByte(int a2) {
        PacketBuffer a3;
        return a3.buf.writeByte(a2);
    }

    public ByteBuf writeShort(int a2) {
        PacketBuffer a3;
        return a3.buf.writeShort(a2);
    }

    public ByteBuf writeShortLE(int a2) {
        PacketBuffer a3;
        return a3.buf.writeShortLE(a2);
    }

    public ByteBuf writeMedium(int a2) {
        PacketBuffer a3;
        return a3.buf.writeMedium(a2);
    }

    public ByteBuf writeMediumLE(int a2) {
        PacketBuffer a3;
        return a3.buf.writeMediumLE(a2);
    }

    public ByteBuf writeInt(int a2) {
        PacketBuffer a3;
        return a3.buf.writeInt(a2);
    }

    public ByteBuf writeIntLE(int a2) {
        PacketBuffer a3;
        return a3.buf.writeIntLE(a2);
    }

    public ByteBuf writeLong(long a2) {
        PacketBuffer a3;
        return a3.buf.writeLong(a2);
    }

    public ByteBuf writeLongLE(long a2) {
        PacketBuffer a3;
        return a3.buf.writeLongLE(a2);
    }

    public ByteBuf writeChar(int a2) {
        PacketBuffer a3;
        return a3.buf.writeChar(a2);
    }

    public ByteBuf writeFloat(float a2) {
        PacketBuffer a3;
        return a3.buf.writeFloat(a2);
    }

    public ByteBuf writeDouble(double a2) {
        PacketBuffer a3;
        return a3.buf.writeDouble(a2);
    }

    public ByteBuf writeBytes(ByteBuf a2) {
        PacketBuffer a3;
        return a3.buf.writeBytes(a2);
    }

    public ByteBuf writeBytes(ByteBuf a2, int a3) {
        PacketBuffer a4;
        return a4.buf.writeBytes(a2, a3);
    }

    public ByteBuf writeBytes(ByteBuf a2, int a3, int a4) {
        PacketBuffer a5;
        return a5.buf.writeBytes(a2, a3, a4);
    }

    public ByteBuf writeBytes(byte[] a2) {
        PacketBuffer a3;
        return a3.buf.writeBytes(a2);
    }

    public ByteBuf writeBytes(byte[] a2, int a3, int a4) {
        PacketBuffer a5;
        return a5.buf.writeBytes(a2, a3, a4);
    }

    public ByteBuf writeBytes(ByteBuffer a2) {
        PacketBuffer a3;
        return a3.buf.writeBytes(a2);
    }

    public int writeBytes(InputStream a2, int a3) throws IOException {
        PacketBuffer a4;
        return a4.buf.writeBytes(a2, a3);
    }

    public int writeBytes(ScatteringByteChannel a2, int a3) throws IOException {
        PacketBuffer a4;
        return a4.buf.writeBytes(a2, a3);
    }

    public int writeBytes(FileChannel a2, long a3, int a4) throws IOException {
        PacketBuffer a5;
        return a5.buf.writeBytes(a2, a3, a4);
    }

    public ByteBuf writeZero(int a2) {
        PacketBuffer a3;
        return a3.buf.writeZero(a2);
    }

    public int writeCharSequence(CharSequence a2, Charset a3) {
        PacketBuffer a4;
        return a4.buf.writeCharSequence(a2, a3);
    }

    public int indexOf(int a2, int a3, byte a4) {
        PacketBuffer a5;
        return a5.buf.indexOf(a2, a3, a4);
    }

    public int bytesBefore(byte a2) {
        PacketBuffer a3;
        return a3.buf.bytesBefore(a2);
    }

    public int bytesBefore(int a2, byte a3) {
        PacketBuffer a4;
        return a4.buf.bytesBefore(a2, a3);
    }

    public int bytesBefore(int a2, int a3, byte a4) {
        PacketBuffer a5;
        return a5.buf.bytesBefore(a2, a3, a4);
    }

    public int forEachByte(ByteProcessor a2) {
        PacketBuffer a3;
        return a3.buf.forEachByte(a2);
    }

    public int forEachByte(int a2, int a3, ByteProcessor a4) {
        PacketBuffer a5;
        return a5.buf.forEachByte(a2, a3, a4);
    }

    public int forEachByteDesc(ByteProcessor a2) {
        PacketBuffer a3;
        return a3.buf.forEachByteDesc(a2);
    }

    public int forEachByteDesc(int a2, int a3, ByteProcessor a4) {
        PacketBuffer a5;
        return a5.buf.forEachByteDesc(a2, a3, a4);
    }

    public ByteBuf copy() {
        PacketBuffer a2;
        return a2.buf.copy();
    }

    public ByteBuf copy(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.copy(a2, a3);
    }

    public ByteBuf slice() {
        PacketBuffer a2;
        return a2.buf.slice();
    }

    public ByteBuf retainedSlice() {
        PacketBuffer a2;
        return a2.buf.retainedSlice();
    }

    public ByteBuf slice(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.slice(a2, a3);
    }

    public ByteBuf retainedSlice(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.retainedSlice(a2, a3);
    }

    public ByteBuf duplicate() {
        PacketBuffer a2;
        return a2.buf.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        PacketBuffer a2;
        return a2.buf.retainedDuplicate();
    }

    public int nioBufferCount() {
        PacketBuffer a2;
        return a2.buf.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        PacketBuffer a2;
        return a2.buf.nioBuffer();
    }

    public ByteBuffer nioBuffer(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.nioBuffer(a2, a3);
    }

    public ByteBuffer internalNioBuffer(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.internalNioBuffer(a2, a3);
    }

    public ByteBuffer[] nioBuffers() {
        PacketBuffer a2;
        return a2.buf.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int a2, int a3) {
        PacketBuffer a4;
        return a4.buf.nioBuffers(a2, a3);
    }

    public boolean hasArray() {
        PacketBuffer a2;
        return a2.buf.hasArray();
    }

    public byte[] array() {
        PacketBuffer a2;
        return a2.buf.array();
    }

    public int arrayOffset() {
        PacketBuffer a2;
        return a2.buf.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        PacketBuffer a2;
        return a2.buf.hasMemoryAddress();
    }

    public long memoryAddress() {
        PacketBuffer a2;
        return a2.buf.memoryAddress();
    }

    public String toString(Charset a2) {
        PacketBuffer a3;
        return a3.buf.toString(a2);
    }

    public String toString(int a2, int a3, Charset a4) {
        PacketBuffer a5;
        return a5.buf.toString(a2, a3, a4);
    }

    public int hashCode() {
        PacketBuffer a2;
        return a2.buf.hashCode();
    }

    public boolean equals(Object a2) {
        PacketBuffer a3;
        return a3.buf.equals(a2);
    }

    public int compareTo(ByteBuf a2) {
        PacketBuffer a3;
        return a3.buf.compareTo(a2);
    }

    public String toString() {
        PacketBuffer a2;
        return a2.buf.toString();
    }

    public ByteBuf retain(int a2) {
        PacketBuffer a3;
        return a3.buf.retain(a2);
    }

    public ByteBuf retain() {
        PacketBuffer a2;
        return a2.buf.retain();
    }

    public ByteBuf touch() {
        PacketBuffer a2;
        return a2.buf.touch();
    }

    public ByteBuf touch(Object a2) {
        PacketBuffer a3;
        return a3.buf.touch(a2);
    }

    public int refCnt() {
        PacketBuffer a2;
        return a2.buf.refCnt();
    }

    public boolean release() {
        PacketBuffer a2;
        return a2.buf.release();
    }

    public boolean release(int a2) {
        PacketBuffer a3;
        return a3.buf.release(a2);
    }
}

