/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.util;

import eos.moe.dragoncore.DragonCore;
import eos.moe.dragoncore.lla;
import eos.moe.dragoncore.util.ImageIOImageData;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(modid="dragoncore")
public class MouseReplacer {
    private static final Map<String, Cursor> cursors = new HashMap<String, Cursor>();
    private static Cursor lastCursor;
    private static String cursor_def;
    private static String cursor_cli;
    private static boolean hasMouseClickPng;

    public MouseReplacer() {
        MouseReplacer a2;
    }

    @SubscribeEvent
    public static void onGuiOpen(GuiOpenEvent a2) {
        cursor_def = "Mouse.png";
        cursor_cli = hasMouseClickPng ? "Mouse_Click.png" : "";
        MouseReplacer.updateNativeCursor(cursor_def);
    }

    @SubscribeEvent
    public static void onMouse(GuiScreenEvent.MouseInputEvent.Pre a2) {
        if (Mouse.getEventButton() != 0) {
            return;
        }
        if (Mouse.getEventButtonState() && !cursor_cli.isEmpty()) {
            MouseReplacer.updateNativeCursor(cursor_cli);
        } else {
            MouseReplacer.updateNativeCursor(cursor_def);
        }
    }

    public static void updateNativeCursor(String a2) {
        MouseReplacer.loadCursor(a2);
        Cursor a3 = cursors.get(a2);
        if (lastCursor == a3) {
            return;
        }
        lastCursor = a3;
        try {
            Mouse.setNativeCursor((Cursor)a3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setCursor(String a2, String a3) {
        cursor_def = a2;
        cursor_cli = a3;
        if (Mouse.isButtonDown((int)0) && !cursor_cli.isEmpty()) {
            MouseReplacer.updateNativeCursor(cursor_cli);
        } else {
            MouseReplacer.updateNativeCursor(cursor_def);
        }
    }

    public static void clear() {
        MouseReplacer.init();
        cursors.clear();
    }

    private static /* synthetic */ void loadCursor(String a2) {
        if (!lla.u) {
            return;
        }
        if (cursors.containsKey(a2)) {
            return;
        }
        IResourceManager a3 = Minecraft.func_71410_x().func_110442_L();
        try {
            IResource a4 = a3.func_110536_a(new ResourceLocation("dragoncore", a2));
            Cursor a5 = MouseReplacer.getCursor(a4.func_110527_b());
            cursors.put(a2, a5);
        }
        catch (FileNotFoundException a6) {
            DragonCore.logHelper.i("\u65e0\u6cd5\u52a0\u8f7d\u7684\u9f20\u6807\u56fe\u7247: \u6587\u4ef6\u7f3a\u5931 Mouse.png");
            cursors.put(a2, null);
        }
        catch (Throwable a7) {
            DragonCore.logHelper.ALLATORIxDEMO("\u65e0\u6cd5\u52a0\u8f7d\u7684\u9f20\u6807\u56fe\u7247:" + a2, a7);
            cursors.put(a2, null);
        }
    }

    public static Cursor getCursor(InputStream a2) throws IOException, LWJGLException {
        int a3;
        int a4 = 0;
        int a5 = 0;
        ImageIOImageData a6 = new ImageIOImageData();
        a6.configureEdging(false);
        ByteBuffer a7 = a6.loadImage(a2, true, true, null);
        for (a3 = 0; a3 < a7.limit(); a3 += 4) {
            byte a8 = a7.get(a3);
            byte a9 = a7.get(a3 + 1);
            byte a10 = a7.get(a3 + 2);
            byte a11 = a7.get(a3 + 3);
            a7.put(a3 + 2, a8);
            a7.put(a3 + 1, a9);
            a7.put(a3, a10);
            a7.put(a3 + 3, a11);
        }
        try {
            a3 = a6.getHeight() - a5 - 1;
            if (a3 < 0) {
                a3 = 0;
            }
            return new Cursor(a6.getTexWidth(), a6.getTexHeight(), a4, a3, 1, a7.asIntBuffer(), null);
        }
        catch (Throwable a12) {
            throw new LWJGLException("Chances are you cursor is too small for this platform", a12);
        }
    }

    public static void init() {
        IResourceManager a2 = Minecraft.func_71410_x().func_110442_L();
        try {
            a2.func_110536_a(new ResourceLocation("dragoncore", "Mouse_Click.png"));
            hasMouseClickPng = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        cursor_def = "Mouse.png";
        cursor_cli = "";
    }
}

