/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz.simple;

import eos.moe.dragoncore.lib.xz.common.ByteArrayView;
import eos.moe.dragoncore.lib.xz.simple.SimpleFilter;

public final class X86
implements SimpleFilter {
    private static final boolean[] MASK_TO_ALLOWED_STATUS = new boolean[]{true, true, true, false, true, false, false, false};
    private static final int[] MASK_TO_BIT_NUMBER = new int[]{0, 1, 2, 2, 3, 3, 3, 3};
    private final boolean isEncoder;
    private int pos;
    private int prevMask = 0;

    private static boolean test86MSByte(byte b2) {
        int i2 = b2 & 0xFF;
        return i2 == 0 || i2 == 255;
    }

    public X86(boolean isEncoder, int startPos) {
        this.isEncoder = isEncoder;
        this.pos = startPos + 5;
    }

    @Override
    public int code(byte[] buf, int off, int len) {
        int i2;
        int prevPos = off - 1;
        int end = off + len - 5;
        for (i2 = off; i2 <= end; ++i2) {
            if ((buf[i2] & 0xFE) != 232) continue;
            if (((prevPos = i2 - prevPos) & 0xFFFFFFFC) != 0) {
                this.prevMask = 0;
            } else {
                this.prevMask = this.prevMask << prevPos - 1 & 7;
                if (this.prevMask != 0 && (!MASK_TO_ALLOWED_STATUS[this.prevMask] || X86.test86MSByte(buf[i2 + 4 - MASK_TO_BIT_NUMBER[this.prevMask]]))) {
                    prevPos = i2;
                    this.prevMask = this.prevMask << 1 | 1;
                    continue;
                }
            }
            prevPos = i2;
            if (X86.test86MSByte(buf[i2 + 4])) {
                int src = ByteArrayView.getIntLE(buf, i2 + 1);
                while (true) {
                    int index;
                    int dest = this.isEncoder ? src + (this.pos + i2 - off) : src - (this.pos + i2 - off);
                    if (this.prevMask == 0 || !X86.test86MSByte((byte)(dest >>> 24 - (index = MASK_TO_BIT_NUMBER[this.prevMask] * 8)))) break;
                    src = dest ^ (1 << 32 - index) - 1;
                }
                dest <<= 7;
                ByteArrayView.setIntLE(buf, i2 + 1, dest >>= 7);
                i2 += 4;
                continue;
            }
            this.prevMask = this.prevMask << 1 | 1;
        }
        this.prevMask = ((prevPos = i2 - prevPos) & 0xFFFFFFFC) != 0 ? 0 : this.prevMask << prevPos - 1;
        this.pos += (i2 -= off);
        return i2;
    }
}

