/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz.simple;

import eos.moe.dragoncore.lib.xz.common.ByteArrayView;
import eos.moe.dragoncore.lib.xz.simple.SimpleFilter;

public final class SPARC
implements SimpleFilter {
    private final boolean isEncoder;
    private int pos;

    public SPARC(boolean isEncoder, int startPos) {
        this.isEncoder = isEncoder;
        this.pos = startPos;
    }

    @Override
    public int code(byte[] buf, int off, int len) {
        int i2;
        int end = off + len - 4;
        for (i2 = off; i2 <= end; i2 += 4) {
            if ((buf[i2] != 64 || (buf[i2 + 1] & 0xC0) != 0) && (buf[i2] != 127 || (buf[i2 + 1] & 0xC0) != 192)) continue;
            int src = ByteArrayView.getIntBE(buf, i2);
            int pc2 = this.pos + i2 - off >>> 2;
            if (!this.isEncoder) {
                pc2 = -pc2;
            }
            int dest = src + pc2;
            dest <<= 9;
            dest >>= 9;
            dest = 0x40000000 | dest & 0x3FFFFFFF;
            ByteArrayView.setIntBE(buf, i2, dest);
        }
        this.pos += (i2 -= off);
        return i2;
    }
}

