/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz.simple;

import eos.moe.dragoncore.lib.xz.common.ByteArrayView;
import eos.moe.dragoncore.lib.xz.simple.SimpleFilter;

public final class RISCVDecoder
implements SimpleFilter {
    private int pos;

    public RISCVDecoder(int startPos) {
        this.pos = startPos;
    }

    @Override
    public int code(byte[] buf, int off, int len) {
        int i2;
        int end = off + len - 8;
        for (i2 = off; i2 <= end; i2 += 2) {
            int inst2;
            int inst = buf[i2] & 0xFF;
            if (inst == 239) {
                int b1 = buf[i2 + 1] & 0xFF;
                if ((b1 & 0xD) != 0) continue;
                int b2 = buf[i2 + 2] & 0xFF;
                int b3 = buf[i2 + 3] & 0xFF;
                int pc2 = this.pos + i2 - off;
                int addr = (b1 & 0xF0) << 13 | b2 << 9 | b3 << 1;
                buf[i2 + 1] = (byte)(b1 & 0xF | (addr -= pc2) >>> 8 & 0xF0);
                buf[i2 + 2] = (byte)(addr >>> 16 & 0xF | addr >>> 7 & 0x10 | addr << 4 & 0xE0);
                buf[i2 + 3] = (byte)(addr >>> 4 & 0x7F | addr >>> 13 & 0x80);
                i2 += 2;
                continue;
            }
            if ((inst & 0x7F) != 23) continue;
            inst |= (buf[i2 + 1] & 0xFF) << 8;
            inst |= (buf[i2 + 2] & 0xFF) << 16;
            if (((inst |= (buf[i2 + 3] & 0xFF) << 24) & 0xE80) != 0) {
                inst2 = ByteArrayView.getIntLE(buf, i2 + 4);
                if (((inst << 8 ^ inst2) & 0xF8003) != 3) {
                    i2 += 4;
                    continue;
                }
                int addr = (inst & 0xFFFFF000) + (inst2 >>> 20);
                inst = 0x117 | inst2 << 12;
                inst2 = addr;
            } else {
                int inst2Rs1 = inst >>> 27;
                if ((inst - 12544 & 0x3F80) >= (inst2Rs1 & 0x1D)) {
                    i2 += 2;
                    continue;
                }
                int addr = ByteArrayView.getIntBE(buf, i2 + 4);
                inst2 = inst >>> 12 | (addr -= this.pos + i2 - off) << 20;
                inst = 0x17 | inst2Rs1 << 7 | addr + 2048 & 0xFFFFF000;
            }
            ByteArrayView.setIntLE(buf, i2, inst);
            ByteArrayView.setIntLE(buf, i2 + 4, inst2);
            i2 += 6;
        }
        this.pos += (i2 -= off);
        return i2;
    }
}

