/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz.simple;

import eos.moe.dragoncore.lib.xz.common.ByteArrayView;
import eos.moe.dragoncore.lib.xz.simple.SimpleFilter;

public final class PowerPC
implements SimpleFilter {
    private final boolean isEncoder;
    private int pos;

    public PowerPC(boolean isEncoder, int startPos) {
        this.isEncoder = isEncoder;
        this.pos = startPos;
    }

    @Override
    public int code(byte[] buf, int off, int len) {
        int i2;
        int end = off + len - 4;
        for (i2 = off; i2 <= end; i2 += 4) {
            if ((buf[i2] & 0xFC) != 72 || (buf[i2 + 3] & 3) != 1) continue;
            int instr = ByteArrayView.getIntBE(buf, i2);
            int pc2 = this.pos + i2 - off;
            if (!this.isEncoder) {
                pc2 = -pc2;
            }
            instr = 0x48000001 | instr + pc2 & 0x3FFFFFC;
            ByteArrayView.setIntBE(buf, i2, instr);
        }
        this.pos += (i2 -= off);
        return i2;
    }
}

