/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz.rangecoder;

import eos.moe.dragoncore.lib.xz.ArrayCache;
import eos.moe.dragoncore.lib.xz.rangecoder.RangeEncoder;
import java.io.IOException;
import java.io.OutputStream;

public final class RangeEncoderToBuffer
extends RangeEncoder {
    private final byte[] buf;
    private int bufPos;

    public RangeEncoderToBuffer(int bufSize, ArrayCache arrayCache) {
        this.buf = arrayCache.getByteArray(bufSize, false);
        this.reset();
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    @Override
    public void reset() {
        super.reset();
        this.bufPos = 0;
    }

    @Override
    public int getPendingSize() {
        return this.bufPos + (int)this.cacheSize + 5 - 1;
    }

    @Override
    public int finish() {
        try {
            super.finish();
        }
        catch (IOException e2) {
            throw new Error();
        }
        return this.bufPos;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.bufPos);
    }

    @Override
    void writeByte(int b2) {
        this.buf[this.bufPos++] = (byte)b2;
    }
}

