/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz.rangecoder;

import eos.moe.dragoncore.lib.xz.ArrayCache;
import eos.moe.dragoncore.lib.xz.CorruptedInputException;
import eos.moe.dragoncore.lib.xz.rangecoder.RangeDecoder;
import java.io.DataInputStream;
import java.io.IOException;

public final class RangeDecoderFromBuffer
extends RangeDecoder {
    private static final int INIT_SIZE = 5;
    private final byte[] buf;
    private int pos;

    public RangeDecoderFromBuffer(int inputSizeMax, ArrayCache arrayCache) {
        this.buf = arrayCache.getByteArray(inputSizeMax - 5, false);
        this.pos = this.buf.length;
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    public void prepareInputBuffer(DataInputStream in2, int len) throws IOException {
        if (len < 5) {
            throw new CorruptedInputException();
        }
        if (in2.readUnsignedByte() != 0) {
            throw new CorruptedInputException();
        }
        this.code = in2.readInt();
        this.range = -1;
        this.pos = this.buf.length - (len -= 5);
        in2.readFully(this.buf, this.pos, len);
    }

    public boolean isFinished() {
        return this.pos == this.buf.length && this.code == 0;
    }

    @Override
    public void normalize() throws IOException {
        if ((this.range & 0xFF000000) == 0) {
            try {
                this.code = this.code << 8 | this.buf[this.pos++] & 0xFF;
                this.range <<= 8;
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                throw new CorruptedInputException();
            }
        }
    }
}

