/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz.common;

import eos.moe.dragoncore.lib.xz.CorruptedInputException;
import eos.moe.dragoncore.lib.xz.UnsupportedOptionsException;
import eos.moe.dragoncore.lib.xz.XZ;
import eos.moe.dragoncore.lib.xz.XZFormatException;
import eos.moe.dragoncore.lib.xz.common.StreamFlags;
import eos.moe.dragoncore.lib.xz.common.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class DecoderUtil
extends Util {
    public static boolean isCRC32Valid(byte[] buf, int off, int len, int ref_off) {
        CRC32 crc32 = new CRC32();
        crc32.update(buf, off, len);
        long value = crc32.getValue();
        for (int i2 = 0; i2 < 4; ++i2) {
            if ((byte)(value >>> i2 * 8) == buf[ref_off + i2]) continue;
            return false;
        }
        return true;
    }

    public static StreamFlags decodeStreamHeader(byte[] buf) throws IOException {
        for (int i2 = 0; i2 < XZ.HEADER_MAGIC.length; ++i2) {
            if (buf[i2] == XZ.HEADER_MAGIC[i2]) continue;
            throw new XZFormatException();
        }
        if (!DecoderUtil.isCRC32Valid(buf, XZ.HEADER_MAGIC.length, 2, XZ.HEADER_MAGIC.length + 2)) {
            throw new CorruptedInputException("XZ Stream Header is corrupt");
        }
        try {
            return DecoderUtil.decodeStreamFlags(buf, XZ.HEADER_MAGIC.length);
        }
        catch (UnsupportedOptionsException e2) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Header");
        }
    }

    public static StreamFlags decodeStreamFooter(byte[] buf) throws IOException {
        StreamFlags streamFlags;
        if (buf[10] != XZ.FOOTER_MAGIC[0] || buf[11] != XZ.FOOTER_MAGIC[1]) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        if (!DecoderUtil.isCRC32Valid(buf, 4, 6, 0)) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        try {
            streamFlags = DecoderUtil.decodeStreamFlags(buf, 8);
        }
        catch (UnsupportedOptionsException e2) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Footer");
        }
        streamFlags.backwardSize = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            streamFlags.backwardSize |= (long)((buf[i2 + 4] & 0xFF) << i2 * 8);
        }
        streamFlags.backwardSize = (streamFlags.backwardSize + 1L) * 4L;
        return streamFlags;
    }

    private static StreamFlags decodeStreamFlags(byte[] buf, int off) throws UnsupportedOptionsException {
        if (buf[off] != 0 || (buf[off + 1] & 0xFF) >= 16) {
            throw new UnsupportedOptionsException();
        }
        StreamFlags streamFlags = new StreamFlags();
        streamFlags.checkType = buf[off + 1];
        return streamFlags;
    }

    public static boolean areStreamFlagsEqual(StreamFlags a2, StreamFlags b2) {
        return a2.checkType == b2.checkType;
    }

    public static long decodeVLI(InputStream in2) throws IOException {
        int b2 = in2.read();
        if (b2 == -1) {
            throw new EOFException();
        }
        long num = b2 & 0x7F;
        int i2 = 0;
        while ((b2 & 0x80) != 0) {
            if (++i2 >= 9) {
                throw new CorruptedInputException();
            }
            b2 = in2.read();
            if (b2 == -1) {
                throw new EOFException();
            }
            if (b2 == 0) {
                throw new CorruptedInputException();
            }
            num |= (long)(b2 & 0x7F) << i2 * 7;
        }
        return num;
    }
}

