/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz.check;

import eos.moe.dragoncore.lib.xz.check.Check;
import eos.moe.dragoncore.lib.xz.common.ByteArrayView;

public class CRC64
extends Check {
    private static final long[][] TABLE = new long[4][256];
    private long crc = -1L;

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        int i2;
        int end = off + len;
        int end4 = end - 3;
        for (i2 = off; i2 < end4; i2 += 4) {
            int tmp = (int)this.crc;
            this.crc = TABLE[3][tmp & 0xFF ^ buf[i2] & 0xFF] ^ TABLE[2][tmp >>> 8 & 0xFF ^ buf[i2 + 1] & 0xFF] ^ this.crc >>> 32 ^ TABLE[1][tmp >>> 16 & 0xFF ^ buf[i2 + 2] & 0xFF] ^ TABLE[0][tmp >>> 24 & 0xFF ^ buf[i2 + 3] & 0xFF];
        }
        while (i2 < end) {
            this.crc = TABLE[0][buf[i2++] & 0xFF ^ (int)this.crc & 0xFF] ^ this.crc >>> 8;
        }
    }

    @Override
    public byte[] finish() {
        byte[] buf = new byte[8];
        ByteArrayView.setLongLE(buf, 0, this.crc ^ 0xFFFFFFFFFFFFFFFFL);
        this.crc = -1L;
        return buf;
    }

    static {
        long poly64 = -3932672073523589310L;
        for (int s2 = 0; s2 < 4; ++s2) {
            for (int b2 = 0; b2 < 256; ++b2) {
                long r2 = s2 == 0 ? (long)b2 : TABLE[s2 - 1][b2];
                for (int i2 = 0; i2 < 8; ++i2) {
                    if ((r2 & 1L) == 1L) {
                        r2 = r2 >>> 1 ^ 0xC96C5795D7870F42L;
                        continue;
                    }
                    r2 >>>= 1;
                }
                CRC64.TABLE[s2][b2] = r2;
            }
        }
    }
}

