/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz;

import eos.moe.dragoncore.lib.xz.ArrayCache;
import eos.moe.dragoncore.lib.xz.BlockOutputStream;
import eos.moe.dragoncore.lib.xz.FilterCoder;
import eos.moe.dragoncore.lib.xz.FilterEncoder;
import eos.moe.dragoncore.lib.xz.FilterOptions;
import eos.moe.dragoncore.lib.xz.FinishableOutputStream;
import eos.moe.dragoncore.lib.xz.RawCoder;
import eos.moe.dragoncore.lib.xz.UnsupportedOptionsException;
import eos.moe.dragoncore.lib.xz.XZ;
import eos.moe.dragoncore.lib.xz.XZIOException;
import eos.moe.dragoncore.lib.xz.check.Check;
import eos.moe.dragoncore.lib.xz.common.EncoderUtil;
import eos.moe.dragoncore.lib.xz.common.StreamFlags;
import eos.moe.dragoncore.lib.xz.index.IndexEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class XZOutputStream
extends FinishableOutputStream {
    private final ArrayCache arrayCache;
    private OutputStream out;
    private final StreamFlags streamFlags = new StreamFlags();
    private final Check check;
    private final IndexEncoder index = new IndexEncoder();
    private BlockOutputStream blockEncoder = null;
    private FilterEncoder[] filters;
    private boolean filtersSupportFlushing;
    private IOException exception = null;
    private boolean finished = false;
    private final byte[] tempBuf = new byte[1];

    public XZOutputStream(OutputStream out, FilterOptions filterOptions) throws IOException {
        this(out, filterOptions, 4);
    }

    public XZOutputStream(OutputStream out, FilterOptions filterOptions, ArrayCache arrayCache) throws IOException {
        this(out, filterOptions, 4, arrayCache);
    }

    public XZOutputStream(OutputStream out, FilterOptions filterOptions, int checkType) throws IOException {
        this(out, new FilterOptions[]{filterOptions}, checkType);
    }

    public XZOutputStream(OutputStream out, FilterOptions filterOptions, int checkType, ArrayCache arrayCache) throws IOException {
        this(out, new FilterOptions[]{filterOptions}, checkType, arrayCache);
    }

    public XZOutputStream(OutputStream out, FilterOptions[] filterOptions) throws IOException {
        this(out, filterOptions, 4);
    }

    public XZOutputStream(OutputStream out, FilterOptions[] filterOptions, ArrayCache arrayCache) throws IOException {
        this(out, filterOptions, 4, arrayCache);
    }

    public XZOutputStream(OutputStream out, FilterOptions[] filterOptions, int checkType) throws IOException {
        this(out, filterOptions, checkType, ArrayCache.getDefaultCache());
    }

    public XZOutputStream(OutputStream out, FilterOptions[] filterOptions, int checkType, ArrayCache arrayCache) throws IOException {
        this.arrayCache = arrayCache;
        this.out = out;
        this.setFiltersForNextBlock(filterOptions);
        this.streamFlags.checkType = checkType;
        this.check = Check.getInstance(checkType);
        this.encodeStreamHeader();
    }

    public void updateFilters(FilterOptions filterOptions) throws XZIOException {
        FilterOptions[] opts = new FilterOptions[]{filterOptions};
        this.updateFilters(opts);
    }

    public void updateFilters(FilterOptions[] filterOptions) throws XZIOException {
        if (this.blockEncoder != null) {
            throw new UnsupportedOptionsException("Changing filter options in the middle of a XZ Block not implemented");
        }
        this.setFiltersForNextBlock(filterOptions);
    }

    private void setFiltersForNextBlock(FilterOptions[] filterOptions) throws XZIOException {
        if (filterOptions.length < 1 || filterOptions.length > 4) {
            throw new UnsupportedOptionsException("XZ filter chain must be 1-4 filters");
        }
        this.filtersSupportFlushing = true;
        FilterCoder[] newFilters = new FilterEncoder[filterOptions.length];
        for (int i2 = 0; i2 < filterOptions.length; ++i2) {
            newFilters[i2] = filterOptions[i2].getFilterEncoder();
            this.filtersSupportFlushing &= newFilters[i2].supportsFlushing();
        }
        RawCoder.validate(newFilters);
        this.filters = newFilters;
    }

    @Override
    public void write(int b2) throws IOException {
        this.tempBuf[0] = (byte)b2;
        this.write(this.tempBuf, 0, 1);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder == null) {
                this.blockEncoder = new BlockOutputStream(this.out, this.filters, this.check, this.arrayCache);
            }
            this.blockEncoder.write(buf, off, len);
        }
        catch (IOException e2) {
            this.exception = e2;
            throw e2;
        }
    }

    public void endBlock() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        if (this.blockEncoder != null) {
            try {
                this.blockEncoder.finish();
                this.index.add(this.blockEncoder.getUnpaddedSize(), this.blockEncoder.getUncompressedSize());
                this.blockEncoder = null;
            }
            catch (IOException e2) {
                this.exception = e2;
                throw e2;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder != null) {
                if (this.filtersSupportFlushing) {
                    this.blockEncoder.flush();
                } else {
                    this.endBlock();
                    this.out.flush();
                }
            } else {
                this.out.flush();
            }
        }
        catch (IOException e2) {
            this.exception = e2;
            throw e2;
        }
    }

    @Override
    public void finish() throws IOException {
        if (!this.finished) {
            this.endBlock();
            try {
                this.index.encode(this.out);
                this.encodeStreamFooter();
            }
            catch (IOException e2) {
                this.exception = e2;
                throw e2;
            }
            this.finished = true;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            block6: {
                try {
                    this.finish();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException e2) {
                    if (this.exception != null) break block6;
                    this.exception = e2;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void encodeStreamFlags(byte[] buf, int off) {
        buf[off] = 0;
        buf[off + 1] = (byte)this.streamFlags.checkType;
    }

    private void encodeStreamHeader() throws IOException {
        this.out.write(XZ.HEADER_MAGIC);
        byte[] buf = new byte[2];
        this.encodeStreamFlags(buf, 0);
        this.out.write(buf);
        EncoderUtil.writeCRC32(this.out, buf);
    }

    private void encodeStreamFooter() throws IOException {
        byte[] buf = new byte[6];
        long backwardSize = this.index.getIndexSize() / 4L - 1L;
        for (int i2 = 0; i2 < 4; ++i2) {
            buf[i2] = (byte)(backwardSize >>> i2 * 8);
        }
        this.encodeStreamFlags(buf, 4);
        EncoderUtil.writeCRC32(this.out, buf);
        this.out.write(buf);
        this.out.write(XZ.FOOTER_MAGIC);
    }
}

