/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz;

import eos.moe.dragoncore.lib.xz.ArrayCache;
import eos.moe.dragoncore.lib.xz.FilterEncoder;
import eos.moe.dragoncore.lib.xz.FilterOptions;
import eos.moe.dragoncore.lib.xz.FinishableOutputStream;
import eos.moe.dragoncore.lib.xz.LZMA2Encoder;
import eos.moe.dragoncore.lib.xz.LZMA2InputStream;
import eos.moe.dragoncore.lib.xz.LZMA2OutputStream;
import eos.moe.dragoncore.lib.xz.UncompressedLZMA2OutputStream;
import eos.moe.dragoncore.lib.xz.UnsupportedOptionsException;
import java.io.IOException;
import java.io.InputStream;

public final class LZMA2Options
extends FilterOptions {
    public static final int PRESET_MIN = 0;
    public static final int PRESET_MAX = 9;
    public static final int PRESET_DEFAULT = 6;
    public static final int DICT_SIZE_MIN = 4096;
    public static final int DICT_SIZE_MAX = 0x30000000;
    public static final int DICT_SIZE_DEFAULT = 0x800000;
    public static final int LC_LP_MAX = 4;
    public static final int LC_DEFAULT = 3;
    public static final int LP_DEFAULT = 0;
    public static final int PB_MAX = 4;
    public static final int PB_DEFAULT = 2;
    public static final int MODE_UNCOMPRESSED = 0;
    public static final int MODE_FAST = 1;
    public static final int MODE_NORMAL = 2;
    public static final int NICE_LEN_MIN = 8;
    public static final int NICE_LEN_MAX = 273;
    public static final int MF_HC4 = 4;
    public static final int MF_BT4 = 20;
    private static final int[] presetToDictSize = new int[]{262144, 0x100000, 0x200000, 0x400000, 0x400000, 0x800000, 0x800000, 0x1000000, 0x2000000, 0x4000000};
    private static final int[] presetToDepthLimit = new int[]{4, 8, 24, 48};
    private int dictSize;
    private byte[] presetDict = null;
    private int lc;
    private int lp;
    private int pb;
    private int mode;
    private int niceLen;
    private int mf;
    private int depthLimit;

    public LZMA2Options() {
        try {
            this.setPreset(6);
        }
        catch (UnsupportedOptionsException e2) {
            assert (false);
            throw new RuntimeException();
        }
    }

    public LZMA2Options(int preset) throws UnsupportedOptionsException {
        this.setPreset(preset);
    }

    public LZMA2Options(int dictSize, int lc2, int lp2, int pb2, int mode, int niceLen, int mf2, int depthLimit) throws UnsupportedOptionsException {
        this.setDictSize(dictSize);
        this.setLcLp(lc2, lp2);
        this.setPb(pb2);
        this.setMode(mode);
        this.setNiceLen(niceLen);
        this.setMatchFinder(mf2);
        this.setDepthLimit(depthLimit);
    }

    public void setPreset(int preset) throws UnsupportedOptionsException {
        if (preset < 0 || preset > 9) {
            throw new UnsupportedOptionsException("Unsupported preset: " + preset);
        }
        this.lc = 3;
        this.lp = 0;
        this.pb = 2;
        this.dictSize = presetToDictSize[preset];
        if (preset <= 3) {
            this.mode = 1;
            this.mf = 4;
            this.niceLen = preset <= 1 ? 128 : 273;
            this.depthLimit = presetToDepthLimit[preset];
        } else {
            this.mode = 2;
            this.mf = 20;
            this.niceLen = preset == 4 ? 16 : (preset == 5 ? 32 : 64);
            this.depthLimit = 0;
        }
    }

    public void setDictSize(int dictSize) throws UnsupportedOptionsException {
        if (dictSize < 4096) {
            throw new UnsupportedOptionsException("LZMA2 dictionary size must be at least 4 KiB: " + dictSize + " B");
        }
        if (dictSize > 0x30000000) {
            throw new UnsupportedOptionsException("LZMA2 dictionary size must not exceed 768 MiB: " + dictSize + " B");
        }
        this.dictSize = dictSize;
    }

    public int getDictSize() {
        return this.dictSize;
    }

    public void setPresetDict(byte[] presetDict) {
        this.presetDict = presetDict;
    }

    public byte[] getPresetDict() {
        return this.presetDict;
    }

    public void setLcLp(int lc2, int lp2) throws UnsupportedOptionsException {
        if (lc2 < 0 || lp2 < 0 || lc2 > 4 || lp2 > 4 || lc2 + lp2 > 4) {
            throw new UnsupportedOptionsException("lc + lp must not exceed 4: " + lc2 + " + " + lp2);
        }
        this.lc = lc2;
        this.lp = lp2;
    }

    public void setLc(int lc2) throws UnsupportedOptionsException {
        this.setLcLp(lc2, this.lp);
    }

    public void setLp(int lp2) throws UnsupportedOptionsException {
        this.setLcLp(this.lc, lp2);
    }

    public int getLc() {
        return this.lc;
    }

    public int getLp() {
        return this.lp;
    }

    public void setPb(int pb2) throws UnsupportedOptionsException {
        if (pb2 < 0 || pb2 > 4) {
            throw new UnsupportedOptionsException("pb must not exceed 4: " + pb2);
        }
        this.pb = pb2;
    }

    public int getPb() {
        return this.pb;
    }

    public void setMode(int mode) throws UnsupportedOptionsException {
        if (mode < 0 || mode > 2) {
            throw new UnsupportedOptionsException("Unsupported compression mode: " + mode);
        }
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setNiceLen(int niceLen) throws UnsupportedOptionsException {
        if (niceLen < 8) {
            throw new UnsupportedOptionsException("Minimum nice length of matches is 8 bytes: " + niceLen);
        }
        if (niceLen > 273) {
            throw new UnsupportedOptionsException("Maximum nice length of matches is 273: " + niceLen);
        }
        this.niceLen = niceLen;
    }

    public int getNiceLen() {
        return this.niceLen;
    }

    public void setMatchFinder(int mf2) throws UnsupportedOptionsException {
        if (mf2 != 4 && mf2 != 20) {
            throw new UnsupportedOptionsException("Unsupported match finder: " + mf2);
        }
        this.mf = mf2;
    }

    public int getMatchFinder() {
        return this.mf;
    }

    public void setDepthLimit(int depthLimit) throws UnsupportedOptionsException {
        if (depthLimit < 0) {
            throw new UnsupportedOptionsException("Depth limit cannot be negative: " + depthLimit);
        }
        this.depthLimit = depthLimit;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    @Override
    public int getEncoderMemoryUsage() {
        return this.mode == 0 ? UncompressedLZMA2OutputStream.getMemoryUsage() : LZMA2OutputStream.getMemoryUsage(this);
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream out, ArrayCache arrayCache) {
        if (this.mode == 0) {
            return new UncompressedLZMA2OutputStream(out, arrayCache);
        }
        return new LZMA2OutputStream(out, this, arrayCache);
    }

    @Override
    public int getDecoderMemoryUsage() {
        int d2 = this.dictSize - 1;
        d2 |= d2 >>> 2;
        d2 |= d2 >>> 3;
        d2 |= d2 >>> 4;
        d2 |= d2 >>> 8;
        d2 |= d2 >>> 16;
        return LZMA2InputStream.getMemoryUsage(d2 + 1);
    }

    @Override
    public InputStream getInputStream(InputStream in2, ArrayCache arrayCache) throws IOException {
        return new LZMA2InputStream(in2, this.dictSize, this.presetDict, arrayCache);
    }

    @Override
    FilterEncoder getFilterEncoder() {
        return new LZMA2Encoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            assert (false);
            throw new RuntimeException();
        }
    }
}

