/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz;

import eos.moe.dragoncore.lib.xz.ArrayCache;
import eos.moe.dragoncore.lib.xz.DeltaEncoder;
import eos.moe.dragoncore.lib.xz.DeltaInputStream;
import eos.moe.dragoncore.lib.xz.DeltaOutputStream;
import eos.moe.dragoncore.lib.xz.FilterEncoder;
import eos.moe.dragoncore.lib.xz.FilterOptions;
import eos.moe.dragoncore.lib.xz.FinishableOutputStream;
import eos.moe.dragoncore.lib.xz.UnsupportedOptionsException;
import java.io.InputStream;

public final class DeltaOptions
extends FilterOptions {
    public static final int DISTANCE_MIN = 1;
    public static final int DISTANCE_MAX = 256;
    private int distance = 1;

    public DeltaOptions() {
    }

    public DeltaOptions(int distance) throws UnsupportedOptionsException {
        this.setDistance(distance);
    }

    public void setDistance(int distance) throws UnsupportedOptionsException {
        if (distance < 1 || distance > 256) {
            throw new UnsupportedOptionsException("Delta distance must be in the range [1, 256]: " + distance);
        }
        this.distance = distance;
    }

    public int getDistance() {
        return this.distance;
    }

    @Override
    public int getEncoderMemoryUsage() {
        return DeltaOutputStream.getMemoryUsage();
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream out, ArrayCache arrayCache) {
        return new DeltaOutputStream(out, this);
    }

    @Override
    public int getDecoderMemoryUsage() {
        return 1;
    }

    @Override
    public InputStream getInputStream(InputStream in2, ArrayCache arrayCache) {
        return new DeltaInputStream(in2, this.distance);
    }

    @Override
    FilterEncoder getFilterEncoder() {
        return new DeltaEncoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            assert (false);
            throw new RuntimeException();
        }
    }
}

