/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz;

import eos.moe.dragoncore.lib.xz.FinishableOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CountingOutputStream
extends FinishableOutputStream {
    private final OutputStream out;
    private long size = 0L;

    public CountingOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b2) throws IOException {
        this.out.write(b2);
        if (this.size >= 0L) {
            ++this.size;
        }
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.out.write(b2, off, len);
        if (this.size >= 0L) {
            this.size += (long)len;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public long getSize() {
        return this.size;
    }
}

