/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz;

import eos.moe.dragoncore.lib.xz.ArrayCache;
import eos.moe.dragoncore.lib.xz.BCJDecoder;
import eos.moe.dragoncore.lib.xz.CorruptedInputException;
import eos.moe.dragoncore.lib.xz.CountingInputStream;
import eos.moe.dragoncore.lib.xz.DeltaDecoder;
import eos.moe.dragoncore.lib.xz.FilterCoder;
import eos.moe.dragoncore.lib.xz.FilterDecoder;
import eos.moe.dragoncore.lib.xz.IndexIndicatorException;
import eos.moe.dragoncore.lib.xz.LZMA2Decoder;
import eos.moe.dragoncore.lib.xz.MemoryLimitException;
import eos.moe.dragoncore.lib.xz.RawCoder;
import eos.moe.dragoncore.lib.xz.UnsupportedOptionsException;
import eos.moe.dragoncore.lib.xz.check.Check;
import eos.moe.dragoncore.lib.xz.common.DecoderUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class BlockInputStream
extends InputStream {
    private final DataInputStream inData;
    private final CountingInputStream inCounted;
    private InputStream filterChain;
    private final Check check;
    private final boolean verifyCheck;
    private long uncompressedSizeInHeader = -1L;
    private long compressedSizeInHeader = -1L;
    private long compressedSizeLimit;
    private final int headerSize;
    private long uncompressedSize = 0L;
    private boolean endReached = false;
    private final byte[] tempBuf = new byte[1];

    public BlockInputStream(InputStream in2, Check check, boolean verifyCheck, int memoryLimit, long unpaddedSizeInIndex, long uncompressedSizeInIndex, ArrayCache arrayCache) throws IOException, IndexIndicatorException {
        int i2;
        int i3;
        this.check = check;
        this.verifyCheck = verifyCheck;
        this.inData = new DataInputStream(in2);
        int b2 = this.inData.readUnsignedByte();
        if (b2 == 0) {
            throw new IndexIndicatorException();
        }
        this.headerSize = 4 * (b2 + 1);
        byte[] buf = new byte[this.headerSize];
        buf[0] = (byte)b2;
        this.inData.readFully(buf, 1, this.headerSize - 1);
        if (!DecoderUtil.isCRC32Valid(buf, 0, this.headerSize - 4, this.headerSize - 4)) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        if ((buf[1] & 0x3C) != 0) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
        }
        int filterCount = (buf[1] & 3) + 1;
        long[] filterIDs = new long[filterCount];
        byte[][] filterProps = new byte[filterCount][];
        ByteArrayInputStream bufStream = new ByteArrayInputStream(buf, 2, this.headerSize - 6);
        try {
            this.compressedSizeLimit = 0x7FFFFFFFFFFFFFFCL - (long)this.headerSize - (long)check.getSize();
            if ((buf[1] & 0x40) != 0) {
                this.compressedSizeInHeader = DecoderUtil.decodeVLI(bufStream);
                if (this.compressedSizeInHeader == 0L || this.compressedSizeInHeader > this.compressedSizeLimit) {
                    throw new CorruptedInputException();
                }
                this.compressedSizeLimit = this.compressedSizeInHeader;
            }
            if ((buf[1] & 0x80) != 0) {
                this.uncompressedSizeInHeader = DecoderUtil.decodeVLI(bufStream);
            }
            for (i3 = 0; i3 < filterCount; ++i3) {
                filterIDs[i3] = DecoderUtil.decodeVLI(bufStream);
                long filterPropsSize = DecoderUtil.decodeVLI(bufStream);
                if (filterPropsSize > (long)bufStream.available()) {
                    throw new CorruptedInputException();
                }
                filterProps[i3] = new byte[(int)filterPropsSize];
                bufStream.read(filterProps[i3]);
            }
        }
        catch (IOException e2) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        for (i3 = bufStream.available(); i3 > 0; --i3) {
            if (bufStream.read() == 0) continue;
            throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
        }
        if (unpaddedSizeInIndex != -1L) {
            int headerAndCheckSize = this.headerSize + check.getSize();
            if ((long)headerAndCheckSize >= unpaddedSizeInIndex) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            long compressedSizeFromIndex = unpaddedSizeInIndex - (long)headerAndCheckSize;
            if (compressedSizeFromIndex > this.compressedSizeLimit || this.compressedSizeInHeader != -1L && this.compressedSizeInHeader != compressedSizeFromIndex) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            if (this.uncompressedSizeInHeader != -1L && this.uncompressedSizeInHeader != uncompressedSizeInIndex) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            this.compressedSizeLimit = compressedSizeFromIndex;
            this.compressedSizeInHeader = compressedSizeFromIndex;
            this.uncompressedSizeInHeader = uncompressedSizeInIndex;
        }
        FilterCoder[] filters = new FilterDecoder[filterIDs.length];
        for (i2 = 0; i2 < filters.length; ++i2) {
            if (filterIDs[i2] == 33L) {
                filters[i2] = new LZMA2Decoder(filterProps[i2]);
                continue;
            }
            if (filterIDs[i2] == 3L) {
                filters[i2] = new DeltaDecoder(filterProps[i2]);
                continue;
            }
            if (BCJDecoder.isBCJFilterID(filterIDs[i2])) {
                filters[i2] = new BCJDecoder(filterIDs[i2], filterProps[i2]);
                continue;
            }
            throw new UnsupportedOptionsException("Unknown Filter ID " + filterIDs[i2]);
        }
        RawCoder.validate(filters);
        if (memoryLimit >= 0) {
            int memoryNeeded = 0;
            for (int i4 = 0; i4 < filters.length; ++i4) {
                memoryNeeded += filters[i4].getMemoryUsage();
            }
            if (memoryNeeded > memoryLimit) {
                throw new MemoryLimitException(memoryNeeded, memoryLimit);
            }
        }
        this.inCounted = new CountingInputStream(in2);
        this.filterChain = this.inCounted;
        for (i2 = filters.length - 1; i2 >= 0; --i2) {
            this.filterChain = filters[i2].getInputStream(this.filterChain, arrayCache);
        }
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.endReached) {
            return -1;
        }
        int ret = this.filterChain.read(buf, off, len);
        if (ret > 0) {
            if (this.verifyCheck) {
                this.check.update(buf, off, ret);
            }
            this.uncompressedSize += (long)ret;
            long compressedSize = this.inCounted.getSize();
            if (compressedSize < 0L || compressedSize > this.compressedSizeLimit || this.uncompressedSize < 0L || this.uncompressedSizeInHeader != -1L && this.uncompressedSize > this.uncompressedSizeInHeader) {
                throw new CorruptedInputException();
            }
            if (ret < len || this.uncompressedSize == this.uncompressedSizeInHeader) {
                if (this.filterChain.read() != -1) {
                    throw new CorruptedInputException();
                }
                this.validate();
                this.endReached = true;
            }
        } else if (ret == -1) {
            this.validate();
            this.endReached = true;
        }
        return ret;
    }

    private void validate() throws IOException {
        long compressedSize = this.inCounted.getSize();
        if (this.compressedSizeInHeader != -1L && this.compressedSizeInHeader != compressedSize || this.uncompressedSizeInHeader != -1L && this.uncompressedSizeInHeader != this.uncompressedSize) {
            throw new CorruptedInputException();
        }
        while ((compressedSize++ & 3L) != 0L) {
            if (this.inData.readUnsignedByte() == 0) continue;
            throw new CorruptedInputException();
        }
        byte[] storedCheck = new byte[this.check.getSize()];
        this.inData.readFully(storedCheck);
        if (this.verifyCheck && !Arrays.equals(this.check.finish(), storedCheck)) {
            throw new CorruptedInputException("Integrity check (" + this.check.getName() + ") does not match");
        }
    }

    @Override
    public int available() throws IOException {
        return this.filterChain.available();
    }

    @Override
    public void close() {
        block2: {
            try {
                this.filterChain.close();
            }
            catch (IOException e2) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.filterChain = null;
    }

    public long getUnpaddedSize() {
        return (long)this.headerSize + this.inCounted.getSize() + (long)this.check.getSize();
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }
}

