/*
 * Decompiled with CFR 0.152.
 */
package eos.moe.dragoncore.lib.xz;

import eos.moe.dragoncore.lib.xz.ArrayCache;
import eos.moe.dragoncore.lib.xz.BCJCoder;
import eos.moe.dragoncore.lib.xz.BCJOptions;
import eos.moe.dragoncore.lib.xz.FilterEncoder;
import eos.moe.dragoncore.lib.xz.FinishableOutputStream;

class BCJEncoder
extends BCJCoder
implements FilterEncoder {
    private final BCJOptions options;
    private final long filterID;
    private final byte[] props;

    BCJEncoder(BCJOptions options, long filterID) {
        assert (BCJEncoder.isBCJFilterID(filterID));
        int startOffset = options.getStartOffset();
        if (startOffset == 0) {
            this.props = new byte[0];
        } else {
            this.props = new byte[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                this.props[i2] = (byte)(startOffset >>> i2 * 8);
            }
        }
        this.filterID = filterID;
        this.options = (BCJOptions)options.clone();
    }

    @Override
    public long getFilterID() {
        return this.filterID;
    }

    @Override
    public byte[] getFilterProps() {
        return this.props;
    }

    @Override
    public boolean supportsFlushing() {
        return false;
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream out, ArrayCache arrayCache) {
        return this.options.getOutputStream(out, arrayCache);
    }
}

